/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.document.server.io.IJSONObject;
import org.simantics.scl.runtime.tuple.Tuple;

public final class JSONObject
extends Bean
implements IJSONObject {
    public final String id;
    public final TreeMap<String, Object> fields = new TreeMap();
    private int hashCode = 0;

    public JSONObject(Binding binding, String id) {
        super(binding);
        assert (binding != null);
        assert (id != null);
        this.id = id.intern();
    }

    public JSONObject(String id) {
        assert (id != null);
        this.id = id.intern();
    }

    public JSONObject clone() {
        JSONObject result = new JSONObject((Binding)this.binding, this.id);
        for (Map.Entry<String, Object> e : this.fields.entrySet()) {
            result.addJSONField(e.getKey(), e.getValue());
        }
        return result;
    }

    public void add(Map<String, Object> fields) {
        for (Map.Entry<String, Object> e : fields.entrySet()) {
            this.addJSONField(e.getKey(), e.getValue());
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.id.hashCode();
            for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value != null) {
                    if (value.getClass().isArray()) {
                        result += JSONObject.objectHashCode(key) ^ this.arrayHashCode(value);
                        continue;
                    }
                    result += JSONObject.objectHashCode(key) ^ JSONObject.objectHashCode(value);
                    continue;
                }
                result += JSONObject.objectHashCode(key);
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    private static int objectHashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    private final boolean arrayEquals(Object av1, Object av2) {
        boolean p2;
        if (av2 == null) {
            return false;
        }
        Class<?> c1 = av1.getClass().getComponentType();
        Class<?> c2 = av2.getClass().getComponentType();
        if (c2 == null || !c1.equals(c2)) {
            return false;
        }
        boolean p1 = c1.isPrimitive();
        if (p1 != (p2 = c2.isPrimitive())) {
            return false;
        }
        if (!p1) {
            return Arrays.equals((Object[])av1, (Object[])av2);
        }
        if (Boolean.TYPE.equals(c1)) {
            return Arrays.equals((boolean[])av1, (boolean[])av2);
        }
        if (Byte.TYPE.equals(c1)) {
            return Arrays.equals((byte[])av1, (byte[])av2);
        }
        if (Integer.TYPE.equals(c1)) {
            return Arrays.equals((int[])av1, (int[])av2);
        }
        if (Long.TYPE.equals(c1)) {
            return Arrays.equals((long[])av1, (long[])av2);
        }
        if (Float.TYPE.equals(c1)) {
            return Arrays.equals((float[])av1, (float[])av2);
        }
        if (Double.TYPE.equals(c1)) {
            return Arrays.equals((double[])av1, (double[])av2);
        }
        throw new RuntimeException("??? Contact application querySupport.");
    }

    private final int arrayHashCode(Object av) {
        if (av == null) {
            return 0;
        }
        Class<?> c1 = av.getClass().getComponentType();
        boolean p1 = c1.isPrimitive();
        if (!p1) {
            return Arrays.hashCode((Object[])av);
        }
        if (Boolean.TYPE.equals(c1)) {
            return Arrays.hashCode((boolean[])av);
        }
        if (Byte.TYPE.equals(c1)) {
            return Arrays.hashCode((byte[])av);
        }
        if (Integer.TYPE.equals(c1)) {
            return Arrays.hashCode((int[])av);
        }
        if (Long.TYPE.equals(c1)) {
            return Arrays.hashCode((long[])av);
        }
        if (Float.TYPE.equals(c1)) {
            return Arrays.hashCode((float[])av);
        }
        if (Double.TYPE.equals(c1)) {
            return Arrays.hashCode((double[])av);
        }
        throw new RuntimeException("??? Contact application querySupport.");
    }

    public boolean equals(Object object) {
        Set<String> otherKeys;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JSONObject)) {
            return false;
        }
        JSONObject o = (JSONObject)((Object)object);
        if (!this.id.equals(o.id)) {
            return false;
        }
        Set<String> keys = this.fields.keySet();
        if (!keys.equals(otherKeys = o.fields.keySet())) {
            return false;
        }
        for (String key : keys) {
            Object value = this.fields.get(key);
            Object otherValue = o.fields.get(key);
            if (!(otherValue != null ? (otherValue.getClass().isArray() ? !this.arrayEquals(otherValue, value) : !otherValue.equals(value)) : value != null)) continue;
            return false;
        }
        return true;
    }

    public void addJSONField(String key, Object content) {
        this.fields.put(key, content);
    }

    public <T> T getJSONField(String key) {
        return (T)this.fields.get(key);
    }

    public <T> T getJSONFieldDefault(String key, T defaultValue) {
        Object value = this.fields.get(key);
        if (value != null) {
            return (T)value;
        }
        return defaultValue;
    }

    public <T> T getBeanJSONFieldDefault(String key, Binding target, T defaultValue) {
        Object value = this.fields.get(key);
        try {
            if (value != null) {
                Binding source = Bindings.getBinding((Datatype)target.type());
                Adapter adapter = Bindings.getAdapter((Binding)source, (Binding)target);
                return (T)adapter.adapt(value);
            }
        }
        catch (AdapterConstructionException adapterConstructionException) {
        }
        catch (AdaptException adaptException) {}
        return defaultValue;
    }

    public String getParent() {
        return (String)this.fields.get("parent");
    }

    public String getParentOrd() {
        return (String)this.fields.get("parentOrd");
    }

    public String getType() {
        return (String)this.fields.get("type");
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            String key = entry.getKey();
            String value = this.fieldJSON(entry.getValue());
            if (value == null) {
                first = true;
                continue;
            }
            b.append('\"');
            b.append(key);
            b.append('\"');
            b.append(':');
            b.append(value);
            b.append("\n");
        }
        b.append("}");
        return b.toString();
    }

    private void printValue(Object value, Binding binding_, StringBuilder sb) throws IOException {
        block16: {
            try {
                block17: {
                    if (!(binding_ instanceof RecordBinding)) break block17;
                    RecordBinding binding = (RecordBinding)binding_;
                    sb.append("{");
                    RecordType type = binding.type();
                    int i = 0;
                    int j = 0;
                    while (i < type.getComponentCount()) {
                        block19: {
                            Binding b;
                            Object field;
                            Component c;
                            block18: {
                                c = type.getComponent(i);
                                field = binding.getComponent(value, i);
                                b = binding.getComponentBinding(i);
                                if (!(b instanceof OptionalBinding)) break block18;
                                OptionalBinding ob = (OptionalBinding)b;
                                if (!ob.hasValueUnchecked(field)) break block19;
                                b = ob.getComponentBinding();
                            }
                            if (j > 0) {
                                sb.append(",");
                            }
                            sb.append("\n");
                            ++j;
                            sb.append("\"");
                            sb.append(c.name);
                            sb.append("\" : ");
                            this.printValue(field, b, sb);
                        }
                        ++i;
                    }
                    sb.append("}");
                    break block16;
                }
                if (binding_ instanceof ArrayBinding) {
                    ArrayBinding binding = (ArrayBinding)binding_;
                    Binding b = binding.getComponentBinding();
                    sb.append("[");
                    int i = 0;
                    while (i < binding.size(value)) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        this.printValue(binding.get(value, i), b, sb);
                        ++i;
                    }
                    sb.append("]");
                } else if (binding_ instanceof MapBinding) {
                    sb.append("{");
                    MapBinding binding = (MapBinding)binding_;
                    int j = 0;
                    Object[] objectArray = binding.getKeys(value);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object key = objectArray[n2];
                        Object val = binding.get(value, key);
                        if (key instanceof String && val instanceof String) {
                            if (j > 0) {
                                sb.append(",");
                            }
                            sb.append("\n");
                            ++j;
                            sb.append("\"");
                            sb.append((String)key);
                            sb.append("\" : \"");
                            sb.append((String)val);
                            sb.append("\"");
                        }
                        ++n2;
                    }
                    sb.append("}");
                } else {
                    DataValueRepository rep = new DataValueRepository();
                    binding_.printValue(value, (Appendable)sb, rep, false);
                }
            }
            catch (BindingException e) {
                e.printStackTrace();
            }
        }
    }

    private String printList(List<?> list) {
        StringBuilder b = new StringBuilder();
        b.append("[");
        boolean first = true;
        for (Object o : list) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(this.fieldJSON(o));
        }
        b.append("]");
        return b.toString();
    }

    private String fieldJSON(Object field) {
        if (field == null) {
            return null;
        }
        String valueString = null;
        if (field instanceof Bean) {
            try {
                Bean bean = (Bean)field;
                StringBuilder sb = new StringBuilder();
                this.printValue(bean, (Binding)bean.getBinding(), sb);
                valueString = sb.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (field instanceof List) {
                return this.printList((List)field);
            }
            if (field instanceof Tuple) {
                Tuple t = (Tuple)field;
                if (t.length() == 2) {
                    Object o1 = t.get(0);
                    Object o2 = t.get(1);
                    if (o1 instanceof String) {
                        return String.valueOf(this.fieldJSON(o1)) + " : " + this.fieldJSON(o2);
                    }
                    return "{" + this.fieldJSON(o1) + " , " + this.fieldJSON(o2) + "}";
                }
                StringBuilder b = new StringBuilder();
                b.append("{");
                int i = 0;
                while (i < t.length()) {
                    if (i > 0) {
                        b.append(",");
                    }
                    b.append(this.fieldJSON(t.get(i)));
                    ++i;
                }
                b.append("}");
                return b.toString();
            }
            if (field.getClass().isArray()) {
                int i;
                Object[] array;
                if (field instanceof float[]) {
                    array = new Float[((float[])field).length];
                    i = 0;
                    while (i < array.length) {
                        array[i] = Float.valueOf(((float[])field)[i]);
                        ++i;
                    }
                } else if (field instanceof int[]) {
                    array = new Integer[((int[])field).length];
                    i = 0;
                    while (i < array.length) {
                        array[i] = ((int[])field)[i];
                        ++i;
                    }
                } else {
                    array = (Object[])field;
                }
                StringBuilder arrayBuilder = new StringBuilder();
                arrayBuilder.append("[");
                int i2 = 0;
                while (i2 < array.length) {
                    Object o = array[i2];
                    if (i2 != 0) {
                        arrayBuilder.append(",");
                    }
                    if (o instanceof String) {
                        arrayBuilder.append("\"");
                    }
                    arrayBuilder.append(o.toString());
                    if (o instanceof String) {
                        arrayBuilder.append("\"");
                    }
                    ++i2;
                }
                arrayBuilder.append("]");
                valueString = arrayBuilder.toString();
            } else {
                valueString = field instanceof String ? JSONObject.quote((String)field) : "\"" + field.toString() + "\"";
            }
        }
        return valueString;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    public String getId() {
        return this.id;
    }

    public <T> T getValue(String key) {
        return (T)this.fields.get(key);
    }

    public Iterator<String> keys() {
        return this.fields.keySet().iterator();
    }

    public IJSONObject clone(Map<String, Object> newObjects) {
        JSONObject result = new JSONObject((Binding)this.binding, this.id);
        for (Map.Entry<String, Object> e : this.fields.entrySet()) {
            result.addJSONField(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, Object> e : newObjects.entrySet()) {
            result.addJSONField(e.getKey(), e.getValue());
        }
        return result;
    }
}

