/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import java.util.List;
import org.simantics.db.procedure.Listener;
import org.simantics.document.server.DocumentHistory;
import org.simantics.document.server.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentHistoryListener
implements Listener<List<JSONObject>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentHistoryListener.class);
    private final DocumentHistory history;
    private boolean disposed = false;

    DocumentHistoryListener(DocumentHistory history) {
        this.history = history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(List<JSONObject> result) {
        DocumentHistory documentHistory = this.history;
        synchronized (documentHistory) {
            this.history.refresh(result);
            if (!this.history.hasListeners()) {
                this.history.removeUpdater();
                this.disposed = true;
            }
        }
    }

    public void exception(Throwable t) {
        LOGGER.warn("DocumentHistoryListener received an exception.", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        if (!this.disposed) {
            DocumentHistory documentHistory = this.history;
            synchronized (documentHistory) {
                if (!this.history.hasListeners()) {
                    this.history.removeUpdater();
                    this.disposed = true;
                }
            }
        }
        return this.disposed;
    }
}

