package org.simantics.document.server.state;

import java.util.Collections;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.simulator.toolkit.StandardNodeManagerSupport;
import org.simantics.simulator.variable.exceptions.NoValueException;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public class StateNodeManagerSupport implements StandardNodeManagerSupport<StateNode> {

	@Override
	public Object getEngineValue(StateNode node) throws NodeManagerException {
		if (node instanceof StatePropertyNode) {
			return ((StatePropertyNode) node).getValue();
		}
		else throw new NoValueException();
	}

	@Override
	public Binding getEngineBinding(StateNode node) throws NodeManagerException {
		if (node instanceof StatePropertyNode) {
			return Bindings.OBJECT;
		}
		else throw new NoValueException();
	}

	@Override
	public void setEngineValue(StateNode node, Object value) throws NodeManagerException {
		if (node instanceof StatePropertyNode) {
			((StatePropertyNode) node).setValue(value);
		}
		else throw new NodeManagerException();
	}

	@Override
	public String getName(StateNode node) {
		if (node instanceof StatePropertyNode) {
			return ((StatePropertyNode) node).getName();
		} else return "@";
	}

	@Override
	public Map<String, StateNode> getChildren(StateNode node) {
		return Collections.emptyMap();
	}

	@Override
	public Map<String, StateNode> getProperties(StateNode node) {
		if (node instanceof StateRootNode) {
			return ((StateRootNode) node).getProperties();
		} else return Collections.emptyMap();
	}

}
