/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.document.linking.report.ExportToPDF;
import org.simantics.document.linking.report.templates.ReportWriter;
import org.simantics.document.linking.wizard.Messages;
import org.simantics.editors.Editors;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class ReportGeneratePage
extends WizardPage {
    private Resource model;
    private String filename;
    private ReportWriter<?> reportWriter;
    private Label fileLabel;
    private Label reportLabel;
    private Label statusLabel;
    private Button generateButton;
    private Button showButton;
    private boolean generated = false;

    protected ReportGeneratePage(String pageName) {
        super(pageName, pageName, null);
        this.setGenerated(false);
    }

    public void setFilename(String filename) {
        this.filename = filename;
        this.setGenerated(false);
    }

    public void setReportWriter(ReportWriter<?> reportWriter) {
        this.reportWriter = reportWriter;
        this.setGenerated(false);
    }

    public void setModel(Resource model) {
        this.model = model;
        this.setGenerated(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.ReportGeneratePage_File);
        this.fileLabel = new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText(Messages.ReportGeneratePage_Report);
        this.reportLabel = new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText(Messages.ReportGeneratePage_Status);
        this.statusLabel = new Label(composite, 0);
        this.statusLabel.setText(Messages.ReportGeneratePage_ReportNotGenerated);
        this.generateButton = new Button(composite, 8);
        this.generateButton.setText(Messages.ReportGeneratePage_GenerateReport);
        this.generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportGeneratePage.this.generate();
            }
        });
        this.showButton = new Button(composite, 8);
        this.showButton.setText(Messages.ReportGeneratePage_ShowReport);
        this.showButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = new File(ReportGeneratePage.this.filename);
                if (file.exists() && file.canRead()) {
                    try {
                        Editors.openExternalEditor((File)file);
                    }
                    catch (PartInitException err) {
                        ExceptionUtils.logAndShowError((Throwable)err);
                    }
                }
            }
        });
        this.showButton.setEnabled(false);
        this.updateContent();
        this.setControl((Control)composite);
    }

    private void updateContent() {
        this.fileLabel.setText(this.filename == null ? Messages.ReportGeneratePage_FileNotSelected : this.filename);
        this.reportLabel.setText(this.reportWriter == null ? Messages.ReportGeneratePage_ReportWriterNotSelected : this.reportWriter.getName());
        this.generateButton.setEnabled(this.filename != null && this.reportWriter != null && this.model != null);
        this.showButton.setEnabled(this.generated);
        this.generateButton.setEnabled(!this.generated);
        if (!this.generated) {
            this.statusLabel.setText(Messages.ReportGeneratePage_ReportNotGenerated);
        }
    }

    public void setGenerated(boolean b) {
        this.generated = b;
        this.setPageComplete(this.generated);
    }

    private void generate() {
        this.generateButton.setEnabled(false);
        this.statusLabel.setText(Messages.ReportGeneratePage_GeneratingReport);
        try {
            this.getWizard().getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ExportToPDF exportToPDF = new ExportToPDF(Simantics.getSession(), ReportGeneratePage.this.model);
                    final IStatus status = exportToPDF.export(ReportGeneratePage.this.filename, ReportGeneratePage.this.reportWriter, monitor);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ReportGeneratePage.this.statusLabel.isDisposed()) {
                                if (status.isOK()) {
                                    ReportGeneratePage.this.statusLabel.setText(status.getMessage());
                                } else {
                                    ReportGeneratePage.this.statusLabel.setText(status.getMessage());
                                    ExceptionUtils.logError((Throwable)status.getException());
                                }
                                ReportGeneratePage.this.setPageComplete(true);
                                ((Composite)ReportGeneratePage.this.getControl()).layout(true, true);
                            }
                        }
                    });
                    monitor.done();
                }
            });
        }
        catch (InterruptedException err) {
            this.setErrorMessage(NLS.bind((String)Messages.ReportGeneratePage_ReportFailed, (Object)err.getMessage()));
            ErrorLogger.defaultLogError((String)Messages.ReportGeneratePage_ReportFail, (Throwable)err);
            this.statusLabel.setText(Messages.ReportGeneratePage_ReportFail);
        }
        catch (InvocationTargetException e) {
            Throwable err = e.getCause();
            this.setErrorMessage(NLS.bind((String)Messages.ReportGeneratePage_ReportFailed, (Object)err.getMessage()));
            ErrorLogger.defaultLogError((String)Messages.ReportGeneratePage_ReportFail, (Throwable)err);
            this.statusLabel.setText(Messages.ReportGeneratePage_ReportFail);
        }
        this.setGenerated(true);
        this.showButton.setEnabled(true);
        this.generateButton.setEnabled(false);
        this.getContainer().updateButtons();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateContent();
        } else {
            this.setGenerated(false);
        }
        super.setVisible(visible);
    }

    public boolean isGenerated() {
        return this.generated;
    }
}

