/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.templates.ModelDocumentWriter;
import org.simantics.document.linking.report.templates.PathComparator;
import org.simantics.document.linking.utils.SourceLinkUtil;

public class ReferredDocumentWriter
extends ModelDocumentWriter {
    @Override
    public String getName() {
        return "Referred Documents";
    }

    @Override
    public List<List<Resource>> getReportItems(ReadGraph graph) throws DatabaseException {
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        Instances instancesQuery = (Instances)graph.adapt(sl.Source, Instances.class);
        Collection found = instancesQuery.find(graph, this.model);
        HashSet<Resource> referred = new HashSet<Resource>();
        for (Resource source : found) {
            Resource ref = SourceLinkUtil.getReferredDocument(graph, source);
            if (ref == null) continue;
            referred.add(ref);
        }
        found = null;
        ArrayList<List<Resource>> result = new ArrayList<List<Resource>>();
        for (Resource ref : referred) {
            if (!graph.isInstanceOf(ref, doc.Document)) continue;
            result.add(SourceLinkUtil.getPath(graph, this.model, ref));
        }
        referred = null;
        Collections.sort(result, new PathComparator(graph));
        return result;
    }
}

