/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.document.linking.report.templates.DiagramStructureWriter;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.utils.datastructures.MapList;

public class DiagramStructureWithDependenciesWriter
extends DiagramStructureWriter {
    @Override
    public String getName() {
        return "Diagram structure with dependencies";
    }

    @Override
    public List<Resource> getReportItems(ReadGraph graph) throws Exception {
        Instances instancesQuery = (Instances)graph.adapt(this.sl.Source, Instances.class);
        Collection found = instancesQuery.find(graph, this.model);
        ArrayList<Resource> list = new ArrayList<Resource>();
        MapList diagramToReference = new MapList();
        for (Resource source : found) {
            Resource parent = graph.getSingleObject(source, this.sl.hasSource_Inverse);
            List<Resource> path = SourceLinkUtil.getPath(graph, this.model, parent);
            for (Resource r : path) {
                Resource doc;
                if (!graph.hasStatement(r, this.mod.CompositeToDiagram) || (doc = SourceLinkUtil.getReferredDocument(graph, source)) == null || diagramToReference.contains((Object)r, (Object)doc)) continue;
                diagramToReference.add((Object)r, (Object)doc);
                list.add(source);
            }
        }
        Collections.sort(list, this.diagramDocumentComparator);
        return list;
    }
}

