/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.html;

import org.simantics.document.linking.report.DocumentElement;
import org.simantics.document.linking.report.TableOfContents;
import org.simantics.document.linking.report.html.HTMLDocument;
import org.simantics.document.linking.report.html.HTMLElement;
import org.simantics.document.linking.report.html.HTMLStreamElement;
import org.simantics.document.linking.report.html.HTMLTable;
import org.simantics.document.linking.report.html.Messages;

public class HTMLTocElement
extends HTMLStreamElement
implements TableOfContents {
    HTMLTable tocTable;

    public HTMLTocElement(HTMLDocument writer) throws Exception {
        super(writer);
        this.os.println(Messages.HTMLTocElement_TocHeading);
        this.tocTable = new HTMLTable(writer, this.os, false);
        this.tocTable.setHeaderVisible(false);
        this.tocTable.setLinesVisible(false);
        this.tocTable.addColumn("Name", 1.0);
    }

    @Override
    public void addTocElement(String label, DocumentElement element) throws Exception {
        HTMLElement e = (HTMLElement)element;
        if (e.getId() == null) {
            throw new IllegalArgumentException("Element has no id " + element);
        }
        this.tocTable.writeRow("<a href=\"#" + e.getId() + "\">" + label + "</a><br>");
    }

    @Override
    public void close() throws Exception {
        this.tocTable.endTable();
        this.os.print("<br>");
        super.close();
    }

    @Override
    public String getId() {
        return "toc";
    }
}

