/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.evaluator.AlignmentHint;
import org.simantics.document.linking.report.evaluator.And;
import org.simantics.document.linking.report.evaluator.Constant;
import org.simantics.document.linking.report.evaluator.Date;
import org.simantics.document.linking.report.evaluator.EvaluatorItem;
import org.simantics.document.linking.report.evaluator.EvaluatorRoot;
import org.simantics.document.linking.report.evaluator.If;
import org.simantics.document.linking.report.evaluator.Lines;
import org.simantics.document.linking.report.evaluator.Or;
import org.simantics.document.linking.report.evaluator.Path;
import org.simantics.document.linking.report.evaluator.TextSizeHint;
import org.simantics.document.linking.report.evaluator.Variable;
import org.simantics.document.linking.report.templates.CustomizableContentProvider;
import org.simantics.document.linking.report.templates.custom.CustomizableContent;
import org.simantics.document.linking.report.templates.custom.EvaluatorCustomizableContent;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.Mappings;
import org.simantics.objmap.graph.schema.IMappingSchema;
import org.simantics.objmap.graph.schema.MappingSchemas;
import org.simantics.objmap.graph.schema.SimpleSchema;

public class DBUtil {
    public static EvaluatorItem load(ReadGraph graph, Resource res) throws DatabaseException {
        IMappingSchema<Resource, Object> schema = DBUtil.getSchema(graph);
        IMapping mapping = Mappings.createWithoutListening(schema);
        EvaluatorItem item = (EvaluatorItem)mapping.map(graph, (Object)res);
        return item;
    }

    public static Resource save(WriteGraph graph, EvaluatorItem item) throws DatabaseException {
        IMappingSchema<Resource, Object> schema = DBUtil.getSchema((ReadGraph)graph);
        IMapping mapping = Mappings.createWithoutListening(schema);
        Resource resource = (Resource)mapping.inverseMap(graph, (Object)item);
        return resource;
    }

    public static IMappingSchema<Resource, Object> getSchema(ReadGraph g) throws DatabaseException {
        try {
            SimpleSchema schema = new SimpleSchema();
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, AlignmentHint.class));
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, And.class));
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, Constant.class));
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, Date.class));
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, EvaluatorRoot.class));
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, If.class));
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, Lines.class));
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, Or.class));
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, TextSizeHint.class));
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, Variable.class));
            schema.addLinkType(MappingSchemas.fromAnnotations((ReadGraph)g, Path.class));
            return schema;
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static void save(WriteGraph graph, CustomizableContentProvider provider, Resource template) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        HashMap<String, Resource> existingEvaluatorTemplates = new HashMap<String, Resource>();
        for (Resource r : graph.getObjects(template, l0.ConsistsOf)) {
            if (!graph.isInstanceOf(r, sl.EvaluatorTree_Template)) continue;
            String id = (String)graph.getRelatedValue(r, l0.HasName);
            existingEvaluatorTemplates.put(id, r);
        }
        for (String id : provider.getContentIds()) {
            CustomizableContent content = provider.getContent(id);
            if (!(content instanceof EvaluatorCustomizableContent)) continue;
            EvaluatorCustomizableContent ecc = (EvaluatorCustomizableContent)content;
            Resource item = DBUtil.save(graph, ecc.getItem());
            Resource treeTemplate = (Resource)existingEvaluatorTemplates.get(id);
            if (treeTemplate == null) {
                treeTemplate = graph.newResource();
                graph.claim(treeTemplate, l0.InstanceOf, sl.EvaluatorTree_Template);
                graph.claimLiteral(treeTemplate, l0.HasName, (Object)id);
                graph.claim(template, l0.ConsistsOf, treeTemplate);
            } else {
                graph.deny(treeTemplate, l0.ConsistsOf);
            }
            graph.claim(treeTemplate, l0.ConsistsOf, item);
        }
    }

    public static void load(ReadGraph graph, Resource template, CustomizableContentProvider provider) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        HashMap<String, Resource> existingEvaluatorTemplates = new HashMap<String, Resource>();
        for (Resource r : graph.getObjects(template, l0.ConsistsOf)) {
            if (!graph.isInstanceOf(r, sl.EvaluatorTree_Template)) continue;
            String id = (String)graph.getRelatedValue(r, l0.HasName);
            existingEvaluatorTemplates.put(id, r);
        }
        for (String id : provider.getContentIds()) {
            Resource treeTemplate = (Resource)existingEvaluatorTemplates.get(id);
            if (treeTemplate == null) continue;
            Resource itemRes = graph.getSingleObject(treeTemplate, l0.ConsistsOf);
            EvaluatorItem item = DBUtil.load(graph, itemRes);
            EvaluatorCustomizableContent ecc = new EvaluatorCustomizableContent(provider.getContent(id).getCustomizationDescription());
            ecc.setItem(item);
            provider.setContent(id, ecc);
        }
    }

    public static List<NamedResource> getTemplates(final Resource library) throws DatabaseException {
        if (library == null) {
            throw new IllegalArgumentException("Library cannot be null");
        }
        List templates = (List)Simantics.getSession().syncRequest((Read)new Read<List<NamedResource>>(){

            public List<NamedResource> perform(ReadGraph graph) throws DatabaseException {
                return DBUtil.getTemplates(graph, library);
            }
        });
        return templates;
    }

    public static List<NamedResource> getTemplates(ReadGraph graph, Resource library) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        Collection templates = (Collection)graph.syncRequest((Read)new ObjectsWithType(library, l0.ConsistsOf, sl.ReportTemplate));
        ArrayList<NamedResource> result = new ArrayList<NamedResource>(templates.size());
        for (Resource template : templates) {
            String name = (String)graph.getRelatedValue(template, l0.HasName);
            result.add(new NamedResource(name, template));
        }
        Collections.sort(result);
        return result;
    }

    public static void save(final Resource library, final String name, final CustomizableContentProvider provider) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                List<NamedResource> templates = DBUtil.getTemplates((ReadGraph)graph, library);
                Resource template = null;
                for (NamedResource nr : templates) {
                    if (!name.equals(nr.getName())) continue;
                    template = nr.getResource();
                    break;
                }
                if (template == null) {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
                    template = graph.newResource();
                    graph.claim(template, l0.InstanceOf, sl.ReportTemplate);
                    graph.claim(library, l0.ConsistsOf, template);
                    graph.claimLiteral(template, l0.HasName, (Object)name);
                }
                DBUtil.save(graph, provider, template);
            }
        });
    }
}

