/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.ge;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.dnd.DndBrowseContext;
import org.simantics.browsing.ui.swt.DefaultExplorerSelectionListener;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.document.linking.ge.MultiSelectionProvider;

public class SourceLinkExplorerComposite
extends GraphExplorerComposite {
    volatile DndBrowseContext dndBrowseContext;
    private IWorkbenchSite site;
    private MultiSelectionProvider provider;

    public SourceLinkExplorerComposite(Map<String, Object> args, MultiSelectionProvider provider, IWorkbenchSite site, Composite parent, WidgetSupport support, int style) {
        super(args, site, parent, support, style);
        this.site = site;
        this.provider = provider;
        this.attachDND();
    }

    public SourceLinkExplorerComposite(Map<String, Object> args, MultiSelectionProvider provider, IWorkbenchSite site, Composite parent, WidgetSupport support, boolean useDND, int style) {
        super(args, site, parent, support, style);
        this.site = site;
        this.provider = provider;
        if (useDND) {
            this.attachDND();
        }
    }

    private void attachDND() {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                ArrayList<Resource> browseContexts = new ArrayList<Resource>();
                for (String uri : SourceLinkExplorerComposite.this.getBrowseContexts()) {
                    Resource browseContext = graph.getPossibleResource(uri);
                    if (browseContext == null) continue;
                    browseContexts.add(browseContext);
                }
                try {
                    SourceLinkExplorerComposite.this.dndBrowseContext = DndBrowseContext.create((ReadGraph)graph, browseContexts);
                }
                catch (InvalidContribution e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
        });
    }

    protected void handleDrop(final Object data, final NodeContext target) {
        if (target == null) {
            return;
        }
        Simantics.getSession().asyncRequest((Read)new Read<Runnable>(){

            public Runnable perform(ReadGraph graph) throws DatabaseException {
                if (SourceLinkExplorerComposite.this.dndBrowseContext == null) {
                    return null;
                }
                return SourceLinkExplorerComposite.this.dndBrowseContext.getAction(graph, target, data);
            }
        }, (Procedure)new Procedure<Runnable>(){

            public void execute(Runnable result) {
                if (result != null) {
                    result.run();
                }
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }
        });
    }

    public void setWorkbenchListeners() {
        if (this.workbenchSelectionListener == null && this.site != null) {
            ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
            this.provider.addSelectionProvider(selectionProvider);
            this.workbenchSelectionListener = new DefaultExplorerSelectionListener(this.site.getPage().getActivePart(), this.explorer);
            this.site.getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.workbenchSelectionListener);
        }
    }
}

