/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.actions;

import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.document.linking.actions.Messages;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.workbench.search.ISearchService;
import org.simantics.workbench.search.SearchQuery;

public class SearchLinksAction
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                try {
                    String name = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                            String s = (String)graph.getPossibleRelatedValue(resource, l0.HasLabel, (Binding)Bindings.STRING);
                            if (s == null) {
                                s = (String)graph.getRelatedValue(resource, l0.HasName, (Binding)Bindings.STRING);
                            }
                            return s;
                        }
                    });
                    ISearchService searchService = (ISearchService)PlatformUI.getWorkbench().getService(ISearchService.class);
                    SearchQuery query = new SearchQuery(name);
                    query.setSearchFlag("NameSearch", "on");
                    query.setSearchFlag("http://www.simantics.org/DocumentLink-1.0/SearchFunction", "on");
                    searchService.performQuery(query, ISearchService.ResultBrowser.VIEW, true);
                }
                catch (DatabaseException e) {
                    ExceptionUtils.logAndShowError((String)Messages.SearchLinksAction_CannotPerformSearch, (Throwable)e);
                }
            }
        };
    }
}

