/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.diagram.internal.DebugPolicy;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;

public class GraphSynchronizationContext
implements IModifiableSynchronizationContext {
    private final IHintContext ctx = new HintContext();

    public GraphSynchronizationContext(ReadGraph graph, IModificationQueue modificationQueue) {
        this.ctx.setHint(GraphSynchronizationHints.SESSION, (Object)graph.getSession());
        this.ctx.setHint(GraphSynchronizationHints.BASIC_RESOURCES, (Object)BasicResources.getInstance(graph));
        this.ctx.setHint(SynchronizationHints.MODIFICATION_QUEUE, (Object)modificationQueue);
    }

    public static GraphSynchronizationContext getWriteInstance(WriteGraph graph, IModificationQueue modificationQueue) {
        GraphSynchronizationContext ctx = new GraphSynchronizationContext((ReadGraph)graph, modificationQueue);
        ctx.ctx.setHint(GraphSynchronizationHints.READ_TRANSACTION, (Object)graph);
        ctx.ctx.setHint(GraphSynchronizationHints.WRITE_TRANSACTION, (Object)graph);
        return ctx;
    }

    @Override
    public <T> T get(IHintContext.Key key) {
        return (T)this.ctx.getHint(key);
    }

    @Override
    public <T> T set(IHintContext.Key key, Object value) {
        if (DebugPolicy.DEBUG_SYNC_CONTEXT) {
            System.out.println(this + ".set(" + key + "): " + value);
        }
        if (value == null) {
            return (T)this.ctx.removeHint(key);
        }
        Object t = this.ctx.getHint(key);
        this.ctx.setHint(key, value);
        return (T)t;
    }
}

