/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.profile.LineUtilities;
import org.simantics.diagram.profile.ProfileKeys;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Relationship;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.RelationshipNode2;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.map.Tuple;

public class ShowRelatedElements
extends StyleBase<Object> {
    protected Collection<Topology.Connection> terminalConnections = new ArrayList<Topology.Connection>(4);
    protected final BasicStroke highlightStroke = new BasicStroke(1.0f, 2, 2, 10.0f, new float[]{4.0f, 6.0f}, 0.0f);
    protected Line2D line = new Line2D.Double();

    @Override
    public Object calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(element, DIA.Monitor)) {
            return this.calculateFromComponent(graph, runtimeDiagram, element, DIA.HasMonitorComponent);
        }
        if (graph.isInstanceOf(element, DIA.Flag)) {
            return this.calculateFromFlag(graph, element);
        }
        return Boolean.TRUE;
    }

    protected Object calculateFromFlag(ReadGraph graph, Resource flag) throws DatabaseException {
        Collection relatedDiagrams;
        Collection flagDiagrams;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource relatedFlag = FlagUtil.getPossibleCounterpart(graph, flag);
        if (relatedFlag != null && !Collections.disjoint(flagDiagrams = OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)flag, (Resource)DIA.Diagram), relatedDiagrams = OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)relatedFlag, (Resource)DIA.Diagram))) {
            AffineTransform flagAt = DiagramGraphUtil.getTransform(graph, flag);
            AffineTransform relatedFlagAt = DiagramGraphUtil.getTransform(graph, relatedFlag);
            return new Relation(Relationship.RELATED_TO.toString(), flag, flagAt, relatedFlag, relatedFlagAt);
        }
        return Boolean.TRUE;
    }

    protected Object calculateFromComponent(ReadGraph graph, Resource runtime, Resource element, Resource elementToComponentRelation) throws DatabaseException {
        Resource parentElement;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource parentComponent = graph.getPossibleObject(element, elementToComponentRelation);
        if (parentComponent != null && (parentElement = graph.getPossibleObject(parentComponent, MOD.ComponentToElement)) != null) {
            AffineTransform at = DiagramGraphUtil.getTransform(graph, element);
            if (graph.isInstanceOf(parentElement, DIA.Connection)) {
                return new Relation(Relationship.CHILD_OF.toString(), element, at, parentElement, this.getConnectionOutputNodePosition(graph, runtime, parentElement));
            }
            AffineTransform parentAt = DiagramGraphUtil.getTransform(graph, parentElement);
            return new Relation(Relationship.CHILD_OF.toString(), element, at, parentElement, parentAt);
        }
        return Boolean.TRUE;
    }

    protected AffineTransform getConnectionOutputNodePosition(ReadGraph graph, Resource runtime, Resource connection) throws DatabaseException {
        Statement toTail = ConnectionUtil.getConnectionTailNodeStatement(graph, connection);
        if (toTail == null) {
            return null;
        }
        AffineTransform at = DiagramGraphUtil.getDynamicAffineTransform(graph, runtime, toTail.getObject());
        Resource connectionPoint = graph.getPossibleInverse(toTail.getPredicate());
        if (connectionPoint == null) {
            return at;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource terminal : graph.getObjects(connectionPoint, DIA.HasConnectionPoint_Inverse)) {
            AffineTransform terminalAt = DiagramGraphUtil.getDynamicAffineTransform(graph, runtime, terminal);
            at.concatenate(terminalAt);
        }
        return at;
    }

    @Override
    public void applyStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item, Object value) {
        INode node = map.getNode(item);
        if (node == null) {
            evaluationContext.update((Style)this, item);
            return;
        }
        if (!(value instanceof Relation)) {
            this.cleanupStyleForNode(node);
            return;
        }
        IDiagram diagram = (IDiagram)evaluationContext.getConstant(ProfileKeys.DIAGRAM);
        Relation r = (Relation)((Object)value);
        DataElementMap emap = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        IElement element = emap.getElement(diagram, item);
        IElement otherElement = emap.getElement(diagram, (Object)r.getOtherElement());
        if (otherElement != null) {
            this.addCorrespondence(r, (G2DParentNode)node, r.getRelation(), element, otherElement, this.highlightStroke, Color.GRAY);
        }
    }

    protected void addCorrespondence(Relation r, G2DParentNode p, String id, IElement from, IElement to, Stroke lineStroke, Color lineColor) {
        Pair<Point2D, Rectangle2D> p1 = this.toPoint(r.getTransform(), from);
        Pair<Point2D, Rectangle2D> p2 = this.toPoint(r.getOtherTransform(), to);
        if (p1 != null && p2 != null) {
            this.addCorrespondence(p, id, p1, p2, lineStroke, lineColor);
        }
    }

    protected Pair<Point2D, Rectangle2D> toPoint(AffineTransform parentTransform, IElement e) {
        if (PickRequest.PickFilter.FILTER_CONNECTIONS.accept(e)) {
            ConnectionHandler ch = (ConnectionHandler)e.getElementClass().getSingleItem(ConnectionHandler.class);
            this.terminalConnections.clear();
            ch.getTerminalConnections(e, this.terminalConnections);
            for (Topology.Connection c : this.terminalConnections) {
                if (c.end != EdgeVisuals.EdgeEnd.Begin) continue;
                BendsHandler bh = (BendsHandler)c.edge.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
                if (bh != null) {
                    ArrayList points = new ArrayList();
                    GeometryUtils.getPoints((Path2D)bh.getPath(c.edge), points);
                    if (points.isEmpty()) continue;
                    return Pair.make((Object)((Point2D)points.get(0)), null);
                }
                AffineTransform at = parentTransform;
                Point2D.Double point = new Point2D.Double(at.getTranslateX(), at.getTranslateY());
                return Pair.make((Object)point, null);
            }
        }
        AffineTransform at = ElementUtils.getTransform((IElement)e);
        Point2D.Double p = new Point2D.Double(at.getTranslateX(), at.getTranslateY());
        Rectangle2D r = ElementUtils.getElementBoundsOnDiagram((IElement)e).getBounds2D();
        return Pair.make((Object)p, (Object)r);
    }

    protected void addCorrespondence(G2DParentNode p, String id, Pair<Point2D, Rectangle2D> p1, Pair<Point2D, Rectangle2D> p2, Stroke lineStroke, Color lineColor) {
        RelationshipNode2 node = (RelationshipNode2)p.getOrCreateNode(id, RelationshipNode2.class);
        node.setZIndex(-10);
        if (p1.second != null) {
            this.line.setLine((Point2D)p1.first, (Point2D)p2.first);
            if (LineUtilities.clipLine(this.line, (Rectangle2D)p1.second)) {
                ((Point2D)p1.first).setLocation(this.line.getX2(), this.line.getY2());
            }
        }
        if (p2.second != null) {
            this.line.setLine((Point2D)p1.first, (Point2D)p2.first);
            if (LineUtilities.clipLine(this.line, (Rectangle2D)p2.second)) {
                ((Point2D)p2.first).setLocation(this.line.getX1(), this.line.getY1());
            }
        }
        node.init(lineStroke, lineColor, (Point2D)p1.first, (Point2D)p2.first);
    }

    @Override
    protected void cleanupStyleForNode(INode node) {
        ProfileVariables.denyChild((INode)node, (String)"", (String)Relationship.CHILD_OF.toString());
        ProfileVariables.denyChild((INode)node, (String)"", (String)Relationship.RELATED_TO.toString());
    }

    public String toString() {
        return "show related elements";
    }

    public static class Relation
    extends Tuple {
        public Relation(String relation, Resource element, AffineTransform elementTransform, Resource otherElement, AffineTransform otherElementTransform) {
            super(new Object[]{relation, element, elementTransform, otherElement, otherElementTransform});
        }

        public String getRelation() {
            return (String)this.getField(0);
        }

        public Resource getElement() {
            return (Resource)this.getField(1);
        }

        public AffineTransform getTransform() {
            return (AffineTransform)this.getField(2);
        }

        public Resource getOtherElement() {
            return (Resource)this.getField(3);
        }

        public AffineTransform getOtherTransform() {
            return (AffineTransform)this.getField(4);
        }
    }
}

