/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant.e4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.e4.ui.services.EContextService;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class ContextUtil
extends AbstractCanvasParticipant {
    private static final boolean DEBUG = false;
    private final EContextService service;
    private final IThreadWorkQueue thread;
    private final Set<String> activations = new HashSet<String>();

    public ContextUtil(EContextService service, IThreadWorkQueue contextManipulationThread) {
        assert (service != null);
        assert (contextManipulationThread != null);
        this.service = service;
        this.thread = contextManipulationThread;
    }

    public void inContextThread(Runnable r) {
        this.exec(r, true);
    }

    private void debug(String s) {
        this.debug(false, s);
    }

    private void debug(boolean trace, String s) {
    }

    private void checkThread() {
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in context thread, use ContextUtil.inContextThread(Runnable)");
        }
    }

    private void exec(Runnable r) {
        this.exec(r, false);
    }

    private void exec(Runnable r, boolean allowSchedule) {
        if (!allowSchedule) {
            this.checkThread();
        }
        if (this.thread.getThread() == null) {
            return;
        }
        if (this.thread.currentThreadAccess()) {
            r.run();
        } else {
            ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)r);
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        this.exec(new Runnable(){

            @Override
            public void run() {
                ContextUtil.this.deactivateAll();
            }
        }, true);
        super.removedFromContext(ctx);
    }

    private void doActivate(String contextId) {
        if (this.activations.add(contextId)) {
            this.service.activateContext(contextId);
        }
    }

    public void activate(final String contextId) {
        this.checkThread();
        assert (contextId != null);
        this.exec(new Runnable(){

            @Override
            public void run() {
                ContextUtil.this.doActivate(contextId);
            }
        });
    }

    public void activate(final Collection<String> contextIds) {
        if (contextIds.isEmpty()) {
            return;
        }
        this.exec(new Runnable(){

            @Override
            public void run() {
                for (String id : contextIds) {
                    ContextUtil.this.doActivate(id);
                }
            }
        });
    }

    public void deactivate(Collection<String> contextIds) {
        this.checkThread();
        assert (contextIds != null);
        for (final String id : contextIds) {
            boolean a = this.activations.remove(id);
            if (!a) continue;
            this.exec(new Runnable(){

                @Override
                public void run() {
                    ContextUtil.this.service.deactivateContext(id);
                }
            });
        }
    }

    public void deactivateAll() {
        this.checkThread();
        final Collection<String> contextIds = this.getActivatedContextIds();
        this.activations.clear();
        this.exec(new Runnable(){

            @Override
            public void run() {
                for (String id : contextIds) {
                    ContextUtil.this.service.deactivateContext(id);
                }
            }
        });
    }

    public synchronized Collection<String> getActivatedContextIds() {
        return Collections.unmodifiableCollection(new ArrayList<String>(this.activations));
    }
}

