/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.Logger;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDragItem;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.utils.logging.TimeLogger;

public abstract class PopulateSelectionDropParticipant
extends AbstractDiagramParticipant
implements IDropTargetParticipant {
    protected GraphToDiagramSynchronizer synchronizer;

    public abstract List<ElementClassDragItem> getElements(Session var1, IStructuredSelection var2) throws DatabaseException;

    public PopulateSelectionDropParticipant(GraphToDiagramSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public void dragEnter(DropTargetDragEvent dtde, IDnDContext dp) {
        Transferable tr = dtde.getTransferable();
        if (tr.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
            Session session = this.synchronizer.getSession();
            Object obj = null;
            try {
                IStructuredSelection sel;
                obj = tr.getTransferData(LocalObjectTransferable.FLAVOR);
                if (!(obj instanceof IStructuredSelection)) {
                    obj = LocalObjectTransfer.getTransfer().getObject();
                }
                if (obj instanceof IStructuredSelection && !(sel = (IStructuredSelection)obj).isEmpty()) {
                    List<ElementClassDragItem> items = this.getElements(session, sel);
                    for (ElementClassDragItem item : items) {
                        dp.add((Object)item);
                    }
                    dp.getHints().setHint(DnDHints.KEY_DND_GRID_COLUMNS, (Object)1);
                }
            }
            catch (UnsupportedFlavorException e) {
                Logger.defaultLogError(e);
            }
            catch (IOException e) {
                Logger.defaultLogError(e);
            }
            catch (DatabaseException e) {
                Logger.defaultLogError(e);
            }
        }
        dtde.acceptDrag(1);
    }

    public void drop(DropTargetDropEvent dtde, IDnDContext dp) {
        TimeLogger.resetTimeAndLog(((Object)((Object)this)).getClass(), (String)"drop");
        IDiagram d = (IDiagram)this.getHint(DiagramHints.KEY_DIAGRAM);
        if (d == null) {
            return;
        }
        DiagramUtils.mutateDiagram((IDiagram)d, m -> {
            IDragItem[] items;
            IDragItem[] iDragItemArray = items = (IDragItem[])dp.toArray();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IDragItem i = iDragItemArray[n2];
                if (i instanceof ElementClassDragItem) {
                    ElementClassDragItem res = (ElementClassDragItem)i;
                    ElementClass ec = res.getElementClass();
                    Point2D pos = dp.getItemPosition(i);
                    assert (pos != null);
                    IElement element = m.newElement(ec);
                    element.setHints(res.getHintContext().getHints());
                    ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getContext().getHintStack().getHint(DiagramHints.SNAP_ADVISOR);
                    if (snapAdvisor != null) {
                        snapAdvisor.snap(pos);
                    }
                    ElementUtils.setPos((IElement)element, (Point2D)pos);
                    dp.remove((Object)i);
                }
                ++n2;
            }
        });
        this.synchronizer.getCanvasContext().getContentContext().setDirty();
    }

    public void dragOver(DropTargetDragEvent dtde, IDnDContext dp) {
    }

    public void dragExit(DropTargetEvent dte, IDnDContext dp) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde, IDnDContext dp) {
    }

    public int getAllowedOps() {
        return 0;
    }

    public double getPriority() {
        return 9.1;
    }
}

