/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Map;
import org.simantics.db.Resource;
import org.simantics.diagram.handler.ElementObjectAssortment;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.scenegraph.g2d.events.command.Command;

public final class PasteOperation {
    public final Command command;
    public final ICanvasContext ctx;
    public final Resource sourceDiagram;
    public final Resource targetDiagram;
    public final IDiagram target;
    public final ElementObjectAssortment ea;
    public final boolean cut;
    public final Point2D offset;
    public Map<Resource, Resource> initialNodeMap;
    public PasteOption[] options;
    public final Map<Object, Object> copyMap;

    public PasteOperation(Command command, ICanvasContext ctx, Resource sourceDiagram, Resource targetDiagram, IDiagram target, ElementObjectAssortment ea, boolean cut, Point2D offset, Map<Resource, Resource> initialNodeMap, Map<Object, Object> copyMap) {
        if (sourceDiagram == null) {
            throw new IllegalArgumentException("null source diagram");
        }
        if (targetDiagram == null) {
            throw new IllegalArgumentException("null target diagram");
        }
        this.command = command;
        this.ctx = ctx;
        this.sourceDiagram = sourceDiagram;
        this.targetDiagram = targetDiagram;
        this.target = target;
        this.ea = ea;
        this.cut = cut;
        this.offset = offset;
        this.copyMap = copyMap;
        this.initialNodeMap = initialNodeMap;
    }

    public PasteOperation(Command command, ICanvasContext ctx, Resource sourceDiagram, Resource targetDiagram, IDiagram target, ElementObjectAssortment ea, boolean cut, Point2D offset, Map<Resource, Resource> initialNodeMap) {
        this(command, ctx, sourceDiagram, targetDiagram, target, ea, cut, offset, initialNodeMap, null);
    }

    public PasteOperation(Command command, ICanvasContext ctx, Resource sourceDiagram, Resource targetDiagram, IDiagram target, ElementObjectAssortment ea, boolean cut, Point2D offset) {
        this(command, ctx, sourceDiagram, targetDiagram, target, ea, cut, offset, Collections.emptyMap());
    }

    public PasteOperation options(PasteOption ... options) {
        this.options = options;
        return this;
    }

    public boolean sameDiagram() {
        return this.sourceDiagram.equals(this.targetDiagram);
    }

    public <T extends PasteOption> T getOption(Class<T> clazz) {
        if (this.options == null) {
            return null;
        }
        PasteOption[] pasteOptionArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            PasteOption option = pasteOptionArray[n2];
            if (clazz.isInstance(option)) {
                return (T)option;
            }
            ++n2;
        }
        return null;
    }

    public <T extends PasteOption> boolean hasOption(Class<T> clazz) {
        return this.getOption(clazz) != null;
    }

    public static enum ForceCopyReferences implements PasteOption
    {
        INSTANCE;

    }

    public static interface PasteOption {
    }
}

