/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.function.Consumer;
import org.simantics.diagram.elements.ITextListener;
import org.simantics.diagram.elements.MonitorClass;
import org.simantics.diagram.elements.TextEditActivation;
import org.simantics.diagram.elements.TextNode;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.HandleMouseEvent;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.utils.Alignment;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TextElementNoBounds
implements SceneGraph,
HandleMouseEvent {
    private static final long serialVersionUID = -148784588840819612L;
    public static final TextElementNoBounds INSTANCE = new TextElementNoBounds();
    public static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(TextNode.class, "TEXT_SG_NODE");
    protected static final double DEFAULT_PADDING_X = 0.5;
    protected static final double DEFAULT_PADDING_Y = 0.5;
    protected static final double DEFAULT_SCALE = 0.235;
    protected final double originX;
    protected final double originY;
    protected final Alignment horizontalAlignment;
    protected final Alignment verticalAlignment;
    protected final double borderWidth;
    protected final boolean editable;
    protected final double paddingX;
    protected final double paddingY;
    protected final double scale;
    TextEditActivation editActivation = null;

    public TextElementNoBounds() {
        this(0.0, 0.0, Alignment.LEADING, 0.0);
    }

    public TextElementNoBounds(double originX, double originY, Alignment horizontalAlignment) {
        this(originX, originY, horizontalAlignment, 0.0);
    }

    public TextElementNoBounds(double originX, double originY, Alignment horizontalAlignment, double borderWidth) {
        this(originX, originY, horizontalAlignment, borderWidth, 0.5, 0.5, true);
    }

    public TextElementNoBounds(double originX, double originY, Alignment horizontalAlignment, double borderWidth, double paddingX, double paddingY, boolean editable) {
        this(originX, originY, horizontalAlignment, borderWidth, paddingX, paddingY, editable, 0.235);
    }

    public TextElementNoBounds(double originX, double originY, Alignment horizontalAlignment, double borderWidth, double paddingX, double paddingY, boolean editable, double scale) {
        this(originX, originY, horizontalAlignment, Alignment.BASELINE, borderWidth, paddingX, paddingY, editable, scale);
    }

    public TextElementNoBounds(double originX, double originY, Alignment horizontalAlignment, Alignment verticalAlignment, double borderWidth, double paddingX, double paddingY, boolean editable, double scale) {
        if (horizontalAlignment == null) {
            throw new NullPointerException("null horizontal alignment");
        }
        this.originX = originX;
        this.originY = originY;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.borderWidth = borderWidth;
        this.editable = editable;
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        this.scale = scale;
    }

    public void init(IElement e, G2DParentNode parent) {
        Rectangle2D bounds;
        TextNode node = this.getOrCreateTextNode(e, parent);
        Font font = ElementUtils.getTextFont((IElement)e);
        Color color = ElementUtils.getTextColor((IElement)e);
        Color fillColor = ElementUtils.getFillColor((IElement)e);
        Color borderColor = ElementUtils.getBorderColor((IElement)e, (Color)Color.BLACK);
        String text = ElementUtils.getText((IElement)e);
        AffineTransform at = ElementUtils.getTransform((IElement)e);
        Alignment hAlign = (Alignment)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)ElementHints.KEY_HORIZONTAL_ALIGN, (Object)this.horizontalAlignment);
        Alignment vAlign = (Alignment)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)ElementHints.KEY_VERTICAL_ALIGN, (Object)this.verticalAlignment);
        Double borderWidth = (Double)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)MonitorClass.KEY_BORDER_WIDTH, (Object)this.borderWidth);
        node.init(text, font, color, this.originX, this.originY, this.scale);
        node.setBackgroundColor(fillColor);
        node.setBorderColor(borderColor);
        node.setHorizontalAlignment((byte)hAlign.ordinal());
        node.setVerticalAlignment((byte)vAlign.ordinal());
        node.setPadding(this.paddingX, this.paddingY);
        node.setBorderWidth(borderWidth.floatValue());
        node.setEditable(this.editable);
        if (at != null) {
            node.setTransform(at);
        }
        if (Boolean.TRUE.equals(ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)ElementHints.KEY_RESIZABLE, (Object)false)) && (bounds = (Rectangle2D)e.getHint(ElementHints.KEY_BOUNDS)) != null) {
            node.setTargetBounds(bounds);
            node.setWrapText(true);
        }
    }

    protected TextNode getOrCreateTextNode(IElement e, G2DParentNode parent) {
        return (TextNode)ElementUtils.getOrCreateNode((IElement)e, (ParentNode)parent, (IHintContext.Key)SG_NODE, (String)"text", TextNode.class, (Consumer)new TextNodeCallBack(e));
    }

    public void cleanup(IElement e) {
        ElementUtils.removePossibleNode((IElement)e, (IHintContext.Key)SG_NODE);
    }

    public boolean handleMouseEvent(IElement e, ICanvasContext ctx, MouseEvent me) {
        if (me instanceof MouseEvent.MouseEnterEvent) {
            e.setHint(ElementHints.KEY_HOVER, (Object)true);
        } else if (me instanceof MouseEvent.MouseExitEvent) {
            e.setHint(ElementHints.KEY_HOVER, (Object)false);
        }
        return false;
    }

    protected void endEdit(TextNode node) {
        if (this.editActivation != null) {
            this.editActivation.release();
            this.editActivation = null;
            node.setEditMode(false);
            node.repaint();
        }
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.borderWidth);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.horizontalAlignment.hashCode();
        temp = Double.doubleToLongBits(this.originX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.originY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.paddingX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.paddingY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextElementNoBounds other = (TextElementNoBounds)obj;
        if (Double.doubleToLongBits(this.borderWidth) != Double.doubleToLongBits(other.borderWidth)) {
            return false;
        }
        if (this.horizontalAlignment != other.horizontalAlignment) {
            return false;
        }
        if (Double.doubleToLongBits(this.originX) != Double.doubleToLongBits(other.originX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.originY) != Double.doubleToLongBits(other.originY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.paddingX) != Double.doubleToLongBits(other.paddingX)) {
            return false;
        }
        return Double.doubleToLongBits(this.paddingY) == Double.doubleToLongBits(other.paddingY);
    }

    private class TextNodeCallBack
    implements Consumer<TextNode> {
        IElement e;

        public TextNodeCallBack(IElement e) {
            this.e = e;
        }

        @Override
        public void accept(TextNode node) {
            node.setTextListener(new ITextListener(){

                @Override
                public void textChanged() {
                }

                @Override
                public void textEditingStarted() {
                }

                @Override
                public void textEditingCancelled() {
                    TextNode node = (TextNode)((Object)TextNodeCallBack.this.e.getHint(SG_NODE));
                    if (node != null) {
                        TextElementNoBounds.this.endEdit(node);
                    }
                }

                @Override
                public void textEditingEnded() {
                    TextNode node = (TextNode)((Object)TextNodeCallBack.this.e.getHint(SG_NODE));
                    if (node == null) {
                        return;
                    }
                    ElementUtils.setText((IElement)TextNodeCallBack.this.e, (String)node.getText());
                    IDiagram diagram = ElementUtils.getDiagram((IElement)TextNodeCallBack.this.e);
                    DiagramUtils.synchronizeHintsToBackend((IDiagram)diagram, (IElement[])new IElement[]{TextNodeCallBack.this.e});
                    TextElementNoBounds.this.endEdit(node);
                }
            });
        }
    }
}

