/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import com.kitfox.svg.Group;
import com.kitfox.svg.Line;
import com.kitfox.svg.Rect;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.Text;
import com.kitfox.svg.Tspan;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.simantics.diagram.elements.EditorStateManager;
import org.simantics.diagram.elements.EditorStateStatic;
import org.simantics.scenegraph.g2d.events.KeyEvent;

class EditorState {
    EditorStateStatic base;
    ModificationClass modificationClass = ModificationClass.NO_EDIT;
    int caretPosition = -1;
    int selectionOtherPosition = -1;
    String currentText = null;

    EditorState() {
    }

    private String selectedText() {
        if (this.editModeHasSelection()) {
            int min = Math.min(this.caretPosition, this.selectionOtherPosition);
            int max = Math.max(this.caretPosition, this.selectionOtherPosition);
            return this.currentText.substring(min, max);
        }
        return null;
    }

    private boolean editModeHasSelection() {
        return this.selectionOtherPosition != -1;
    }

    private void editModeClearSelection() {
        this.selectionOtherPosition = -1;
    }

    private void deleteCurrentSelection() {
        int min = Math.min(this.caretPosition, this.selectionOtherPosition);
        int max = Math.max(this.caretPosition, this.selectionOtherPosition);
        this.currentText = String.valueOf(this.currentText.substring(0, min)) + this.currentText.substring(max, this.currentText.length());
        this.caretPosition = min;
        this.editModeClearSelection();
    }

    public void applyEditMode(SVGDiagram diagram) throws SVGException {
        Text text = (Text)diagram.getElement(this.base.textElementId);
        Tspan span = (Tspan)text.getContent().get(0);
        span.setText(String.valueOf(this.currentText) + EditorStateManager.TERM_STRING);
        text.rebuild();
        diagram.updateTime(0.0);
        double textWidth = text.getBoundingBox().getWidth() - this.base.termStringWidth;
        span.setText(String.valueOf(this.currentText.substring(0, this.caretPosition)) + EditorStateManager.TERM_STRING);
        text.rebuild();
        diagram.updateTime(0.0);
        double caretRectWidth = text.getBoundingBox().getWidth() - this.base.termStringWidth;
        double selectionOtherWidth = 0.0;
        if (this.selectionOtherPosition != -1) {
            span.setText(String.valueOf(this.currentText.substring(0, this.selectionOtherPosition)) + EditorStateManager.TERM_STRING);
            text.rebuild();
            diagram.updateTime(0.0);
            selectionOtherWidth = text.getBoundingBox().getWidth() - this.base.termStringWidth;
        }
        span.setText(this.currentText);
        text.rebuild();
        diagram.updateTime(0.0);
        Rectangle2D finalBB = text.getBoundingBox();
        Group group = (Group)text.getParent();
        Line line = new Line();
        group.removeChild((SVGElement)text);
        double xPadding = 0.0;
        double minY = this.base.verticalDimensions.getMinY() - 1.0;
        double height = this.base.verticalDimensions.getHeight() + 2.0;
        Rect rect = new Rect();
        rect.addAttribute("x", 1, "" + (finalBB.getMinX() - xPadding));
        rect.addAttribute("y", 1, "" + minY);
        rect.addAttribute("width", 1, "" + (textWidth + xPadding));
        rect.addAttribute("height", 1, "" + height);
        rect.addAttribute("fill", 1, "#ccc");
        group.loaderAddChild(null, (SVGElement)rect);
        double caretX = finalBB.getMinX() + caretRectWidth;
        if (this.selectionOtherPosition != -1) {
            double selectionX = finalBB.getMinX() + selectionOtherWidth;
            Rect selection = new Rect();
            if (this.selectionOtherPosition < this.caretPosition) {
                selection.addAttribute("x", 1, "" + selectionX);
                selection.addAttribute("y", 1, "" + minY);
                selection.addAttribute("width", 1, "" + (caretX - selectionX));
                selection.addAttribute("height", 1, "" + height);
                selection.addAttribute("fill", 1, "#888");
            } else {
                selection.addAttribute("x", 1, "" + caretX);
                selection.addAttribute("y", 1, "" + minY);
                selection.addAttribute("width", 1, "" + (selectionX - caretX));
                selection.addAttribute("height", 1, "" + height);
                selection.addAttribute("fill", 1, "#888");
            }
            group.loaderAddChild(null, (SVGElement)selection);
        }
        line.addAttribute("x1", 1, "" + caretX);
        line.addAttribute("x2", 1, "" + caretX);
        line.addAttribute("y1", 1, "" + (this.base.verticalDimensions.getMinY() - 1.0));
        line.addAttribute("y2", 1, "" + (this.base.verticalDimensions.getMaxY() + 1.0));
        line.addAttribute("stroke", 1, "black");
        line.addAttribute("stroke-width", 1, "0.5");
        group.loaderAddChild(null, (SVGElement)line);
        group.loaderAddChild(null, (SVGElement)text);
        diagram.updateTime(0.0);
    }

    boolean keyPressed(EditorStateManager esm, KeyEvent.KeyPressedEvent e) {
        boolean result = this.keyPressedInternal(esm, e);
        if (this.selectionOtherPosition == this.caretPosition) {
            this.editModeClearSelection();
        }
        return result;
    }

    private void performDelete() {
        if (this.editModeHasSelection()) {
            this.deleteCurrentSelection();
            this.modificationClass = ModificationClass.AREA_DELETE;
        } else {
            if (this.caretPosition < this.currentText.length()) {
                this.currentText = String.valueOf(this.currentText.substring(0, this.caretPosition)) + this.currentText.substring(this.caretPosition + 1, this.currentText.length());
            }
            this.modificationClass = ModificationClass.SINGLE_DELETE;
        }
    }

    private void performCopy() {
        String selection = this.selectedText();
        if (selection == null) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(selection), null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean keyPressedInternal(EditorStateManager esm, KeyEvent.KeyPressedEvent e) {
        if (e.keyCode == 8) {
            if (this.editModeHasSelection()) {
                this.deleteCurrentSelection();
                this.modificationClass = ModificationClass.AREA_DELETE;
            } else {
                if (this.caretPosition > 0) {
                    this.currentText = String.valueOf(this.currentText.substring(0, this.caretPosition - 1)) + this.currentText.substring(this.caretPosition, this.currentText.length());
                    --this.caretPosition;
                }
                this.modificationClass = ModificationClass.SINGLE_DELETE;
            }
        } else if (127 == e.keyCode) {
            this.performDelete();
        } else {
            if (67 == e.keyCode && e.isControlDown()) {
                this.performCopy();
                return false;
            }
            if (88 == e.keyCode && e.isControlDown()) {
                this.performCopy();
                this.performDelete();
            } else if (86 == e.keyCode && e.isControlDown()) {
                DataFlavor dataFlavor;
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (!clipboard.isDataFlavorAvailable(dataFlavor = DataFlavor.stringFlavor)) return false;
                try {
                    String text = clipboard.getData(dataFlavor).toString();
                    if (this.editModeHasSelection()) {
                        this.deleteCurrentSelection();
                    }
                    this.currentText = String.valueOf(this.currentText.substring(0, this.caretPosition)) + text + this.currentText.substring(this.caretPosition, this.currentText.length());
                    this.caretPosition += text.length();
                    this.modificationClass = ModificationClass.AREA_INSERT;
                }
                catch (UnsupportedFlavorException | IOException exception) {}
            } else if (65 == e.keyCode && e.isControlDown()) {
                this.caretPosition = 0;
                this.selectionOtherPosition = this.currentText.length();
            } else {
                if (90 == e.keyCode && e.isControlDown()) {
                    esm.undo();
                    return false;
                }
                if (89 == e.keyCode && e.isControlDown()) {
                    esm.redo();
                    return false;
                }
                if (27 == e.keyCode) {
                    esm.deactivateEdit();
                } else if (37 == e.keyCode) {
                    if (!e.isShiftDown() && this.editModeHasSelection()) {
                        if (this.selectionOtherPosition < this.caretPosition) {
                            this.caretPosition = this.selectionOtherPosition;
                        }
                        this.editModeClearSelection();
                    } else {
                        if (e.isShiftDown() && !this.editModeHasSelection()) {
                            this.selectionOtherPosition = this.caretPosition;
                        }
                        if (this.caretPosition > 0) {
                            --this.caretPosition;
                        }
                    }
                } else if (39 == e.keyCode) {
                    if (!e.isShiftDown() && this.editModeHasSelection()) {
                        if (this.selectionOtherPosition > this.caretPosition) {
                            this.caretPosition = this.selectionOtherPosition;
                        }
                        this.editModeClearSelection();
                    } else {
                        if (e.isShiftDown() && !this.editModeHasSelection()) {
                            this.selectionOtherPosition = this.caretPosition;
                        }
                        if (this.caretPosition < this.currentText.length()) {
                            ++this.caretPosition;
                        }
                    }
                } else if (35 == e.keyCode) {
                    if (e.isShiftDown()) {
                        if (!this.editModeHasSelection()) {
                            this.selectionOtherPosition = this.caretPosition;
                        }
                    } else {
                        this.editModeClearSelection();
                    }
                    this.caretPosition = this.currentText.length();
                } else if (36 == e.keyCode) {
                    if (e.isShiftDown()) {
                        if (!this.editModeHasSelection()) {
                            this.selectionOtherPosition = this.caretPosition;
                        }
                    } else {
                        this.editModeClearSelection();
                    }
                    this.caretPosition = 0;
                } else if (10 == e.keyCode) {
                    esm.applyEdit();
                    esm.deactivateEdit();
                } else {
                    if (!this.isAllowedCharacter(e)) return false;
                    if (this.editModeHasSelection()) {
                        this.deleteCurrentSelection();
                    }
                    this.currentText = String.valueOf(this.currentText.substring(0, this.caretPosition)) + e.character + this.currentText.substring(this.caretPosition, this.currentText.length());
                    ++this.caretPosition;
                    this.modificationClass = ModificationClass.SINGLE_INSERT;
                }
            }
        }
        esm.paint();
        return true;
    }

    void replace(EditorState other) {
        this.base = other.base;
        this.caretPosition = other.caretPosition;
        this.currentText = other.currentText;
        this.selectionOtherPosition = other.selectionOtherPosition;
    }

    boolean shouldReplace(EditorState comparedTo) {
        return this.modificationClass.equals((Object)comparedTo.modificationClass);
    }

    EditorState copy() {
        EditorState result = new EditorState();
        result.replace(this);
        return result;
    }

    private boolean isAllowedCharacter(KeyEvent.KeyPressedEvent e) {
        char c = e.character;
        return c != '\uffff' && Character.getType(c) != 15;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + this.caretPosition;
        result = 31 * result + (this.currentText == null ? 0 : this.currentText.hashCode());
        result = 31 * result + (this.modificationClass == null ? 0 : this.modificationClass.hashCode());
        result = 31 * result + this.selectionOtherPosition;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditorState other = (EditorState)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        if (this.caretPosition != other.caretPosition) {
            return false;
        }
        if (this.currentText == null ? other.currentText != null : !this.currentText.equals(other.currentText)) {
            return false;
        }
        if (this.modificationClass != other.modificationClass) {
            return false;
        }
        return this.selectionOtherPosition == other.selectionOtherPosition;
    }

    static enum ModificationClass {
        SINGLE_INSERT,
        AREA_INSERT,
        SINGLE_DELETE,
        AREA_DELETE,
        NO_EDIT;

    }
}

