/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.flag.DiagramFlagPreferences;
import org.simantics.diagram.flag.FlagLabelingScheme;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.ElementWriter;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.elementclass.FlagHandler;
import org.simantics.layer0.Layer0;

public class FlagWriter
implements ElementWriter {
    @Override
    public void addToGraph(WriteGraph g, IElement flag, Resource flagResource) throws DatabaseException {
        DiagramResource dia = DiagramResource.getInstance((ReadGraph)g);
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        FlagHandler fh = (FlagHandler)flag.getElementClass().getSingleItem(FlagHandler.class);
        FlagClass.Type type = fh.getType(flag);
        String text = ElementUtils.getText((IElement)flag);
        if (text != null && text.isEmpty()) {
            text = null;
        }
        g.deny(flagResource, dia.HasFlagType);
        g.claim(flagResource, dia.HasFlagType, null, DiagramGraphUtil.toFlagTypeResource(dia, type));
        Resource counterpart = null;
        FlagClass.Connection conn = fh.getConnection(flag);
        if (conn != null) {
            IElement counterpartE = fh.getCorrespondence(flag);
            IDiagram od = ElementUtils.getDiagram((IElement)counterpartE);
            DataElementMap dem = (DataElementMap)od.getDiagramClass().getSingleItem(DataElementMap.class);
            counterpart = (Resource)dem.getData(od, counterpartE);
        }
        if (counterpart != null) {
            FlagUtil.join(g, flagResource, counterpart);
            Resource diagram = OrderedSetUtils.getSingleOwnerList((ReadGraph)g, (Resource)flagResource, (Resource)dia.Diagram);
            Resource counterpartDiagram = OrderedSetUtils.getSingleOwnerList((ReadGraph)g, counterpart, (Resource)dia.Diagram);
            if (diagram.equals(counterpartDiagram)) {
                FlagLabelingScheme scheme;
                if (text == null && (scheme = DiagramFlagPreferences.getActiveFlagLabelingScheme((RequestProcessor)g)) != null) {
                    text = scheme.generateLabel((ReadGraph)g, diagram);
                }
                if (text != null) {
                    g.claimLiteral(flagResource, l0.HasLabel, dia.FlagLabel, (Object)text, (Binding)Bindings.STRING);
                    g.claimLiteral(counterpart, l0.HasLabel, dia.FlagLabel, (Object)text, (Binding)Bindings.STRING);
                }
            }
        }
    }

    @Override
    public void removeFromGraph(WriteGraph graph, Resource flag) throws DatabaseException {
        FlagUtil.disconnectFlag(graph, flag);
    }
}

