/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbollibrary.ui;

/**
 * @author Tuukka Lehtonen
 */
class GroupFilter implements Comparable<GroupFilter> {
    private String name;
    private String filterText;
    private boolean active;

    public GroupFilter(String name, String filterText, boolean active) {
        assert name != null;
        assert filterText != null;
        this.name = name;
        this.filterText = filterText;
        this.active = active;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilterText() {
        return filterText;
    }

    public void setFilterText(String filterText) {
        this.filterText = filterText;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + name + ", filter=" + filterText + ", active=" + active + "]";
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + filterText.hashCode();
        result = prime * result + name.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof GroupFilter))
            return false;
        GroupFilter other = (GroupFilter) obj;
        if (!filterText.equals(other.filterText))
            return false;
        if (!name.equals(other.name))
            return false;
        return true;
    }

    @Override
    public int compareTo(GroupFilter o) {
        return name.compareToIgnoreCase(o.name);
    }
}