/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.ontology.ScenegraphResources;

/**
 * @author Tuukka Lehtonen
 */
public class FlagTypeVisuals extends ResourceRead<List<FlagTypeVisual>> {

    public FlagTypeVisuals(Resource flagTable) {
        super(flagTable);
    }

    @Override
    public List<FlagTypeVisual> perform(ReadGraph g) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(g);
        ScenegraphResources SG = ScenegraphResources.getInstance(g);

        Resource list = g.getPossibleObject(resource, SG.Node_children);
        if (list == null || !g.isInstanceOf(list, L0.List))
            return Collections.emptyList();

        DiagramResource DIA = DiagramResource.getInstance(g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);

        Collection<Resource> flagTypeVisuals = ListUtils.toList(g, list);
        List<FlagTypeVisual> result = new ArrayList<FlagTypeVisual>(flagTypeVisuals.size());

        for (Resource flagTypeVisual : flagTypeVisuals) {
            if (!g.isInstanceOf(flagTypeVisual, TEMPLATE2D.FlagTypeVisual))
                continue;

            String reference = null;
            String pattern = null;
            Resource visualComposite = null;

            Collection<Resource> children = g.getObjects(flagTypeVisual, L0.ConsistsOf);
            for (Resource child : children) {
                if (g.isInstanceOf(child, TEMPLATE2D.FlagTypeVisual_Filter)) {
                    reference = g.getPossibleRelatedValue2(child, TEMPLATE2D.FlagTypeVisual_Filter_HasProperty, Bindings.STRING);
                    pattern = g.getPossibleRelatedValue2(child, TEMPLATE2D.FlagTypeVisual_Filter_HasPattern, Bindings.STRING);
                }
                if (g.isInstanceOf(child, DIA.Scenegraph_Composite)) {
                    visualComposite = child;
                }
            }

            if (visualComposite != null)
                result.add( new FlagTypeVisual(flagTypeVisual, reference, pattern, visualComposite) );
        }

        return result;
    }

}
