package org.simantics.diagram.export;

import java.util.Collection;
import java.util.Collections;

import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.DiscoverAction;
import org.simantics.export.core.util.ExportQueries;

/**
 * Discovers all models in context ( session, project )
 *
 * @author toni.kalajainen@semantum.fi
 */
public class DiscoverDiagrams implements DiscoverAction {

	public Read<Collection<String>> discoverRequest(
			final Collection<String> startLocations) throws ExportException {
		return ExportQueries.instancesOf(startLocations, DiagramResource.URIs.Diagram);			
	}
	
	@Override
	public Collection<String> discoverContent(ExportContext ctx, Collection<String> startLocations) throws ExportException {		
// Disabled for now.
//		try {
//			return ctx.session.syncRequest( discoverRequest(startLocations) );		
//		} catch (DatabaseException e) {
//			if ( e.getCause() instanceof ExportException ) throw (ExportException) e.getCause();
//			throw new ExportException( e );
//		}
		return Collections.emptyList();
	}
	

}
