/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import java.util.Collection;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.model.check.CheckedStateRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.view.ProfileTuple;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.ProfileUtils;
import org.simantics.scenegraph.profile.request.ProfileActiveEntryResources;
import org.simantics.scenegraph.profile.request.ProfileEntryResources;

public class ProfileCheckContributor
implements CheckedStateRule {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(ProfileTuple.class);
    }

    public CheckedState getCheckedState(ReadGraph graph, Object parent) throws DatabaseException {
        ProfileTuple tuple = (ProfileTuple)((Object)parent);
        Resource activeProfile = tuple.getBaseProfile();
        Resource entry = tuple.getEntry();
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(entry, DIA.Profile)) {
            Resource list = graph.getPossibleObject(entry, DIA.HasEntries);
            Collection activeEntries = (Collection)graph.syncRequest((Read)new ProfileActiveEntryResources(activeProfile, list));
            if (activeEntries.isEmpty()) {
                return CheckedState.NOT_CHECKED;
            }
            Collection entries = (Collection)graph.syncRequest((Read)new ProfileEntryResources(activeProfile, list));
            return entries.equals(activeEntries) ? CheckedState.CHECKED : CheckedState.GRAYED;
        }
        if (ProfileUtils.isActive((ReadGraph)graph, (Resource)tuple.getRuntimeDiagram(), (Resource)activeProfile, (Resource)entry)) {
            return CheckedState.CHECKED;
        }
        return CheckedState.NOT_CHECKED;
    }
}

