package org.simantics.diagram.profile.view;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.Resource;
import org.simantics.utils.datastructures.map.Tuple;

public class ProfileTuple extends Tuple implements IAdaptable {

    ProfileTuple(Resource baseProfile, Resource entry, Resource runtimeDiagram) {
        super(baseProfile, entry, runtimeDiagram);
    }

    public Resource getBaseProfile()    { return (Resource) getField(0); }
    public Resource getEntry()          { return (Resource) getField(1); }
    public Resource getRuntimeDiagram() { return (Resource) getField(2); }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == Resource.class) {
            return (T) getEntry();
        }
        return null;
    }

}