package org.simantics.diagram.profile.view;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.ProfileUtils;
import org.simantics.simulation.ontology.SimulationResource;

public class ProfileEntrySelectionListener implements Listener {

    public void processRecursively(WriteGraph graph, Resource runtimeProfile, Resource entry, boolean checked) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance(graph);

        if (graph.isInstanceOf(entry, DIA.Profile)) {
            for (Resource child : ProfileUtils.getProfileChildren(graph, entry)) {
                processRecursively(graph, runtimeProfile, child, checked);
            }
        } else if (graph.isInstanceOf(entry, DIA.ProfileEntry)) {
            if (checked) {
                graph.claim(runtimeProfile, SimulationResource.getInstance(graph).IsActive, null, entry);
            } else {
                graph.denyStatement(runtimeProfile, SimulationResource.getInstance(graph).IsActive, entry);
            }
        }
    }

    @Override
    public void handleEvent (Event event) {
        if(event.detail == SWT.CHECK) {
            final TreeItem item = (TreeItem)event.item;
            Tree tree = item.getParent();
            GraphExplorer explorer = (GraphExplorer)tree.getData(GraphExplorer.KEY_GRAPH_EXPLORER);
            final Resource runtimeDiagram = (Resource)explorer.getRoot().getConstant(BuiltinKeys.INPUT);
            final boolean checked = item.getChecked();
            NodeContext context = (NodeContext)item.getData();
            final ProfileTuple entry = (ProfileTuple)context.getConstant(BuiltinKeys.INPUT);
            try {
                VirtualGraphSupport support = Simantics.getSession().getService(VirtualGraphSupport.class);
                Simantics.getSession().syncRequest(new WriteRequest(support.getWorkspacePersistent("profiles")) {

                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                        DiagramResource DIA = DiagramResource.getInstance(graph);
                        Resource runtimeProfile = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
                        processRecursively(graph, runtimeProfile, entry.getEntry(), checked);
                    }

                });
            } catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

}
