package org.simantics.diagram.profile.view;

import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledActionImpl;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.Logger;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

public class CreateGroupAction extends ModelledActionImpl<Resource> {

	public CreateGroupAction(Resource configuration) {
		super(configuration);
	}
	
	public void run(final Resource runtimeDiagram) {

		try {
		
			Simantics.getSession().syncRequest(new WriteRequest() {
	
				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
	
					Layer0 L0 = Layer0.getInstance(graph);
					Layer0X L0X = Layer0X.getInstance(graph);
					DiagramResource DIA = DiagramResource.getInstance(graph);
			        String modelURI = graph.getPossibleRelatedValue((Resource)runtimeDiagram, DIA.RuntimeDiagram_HasModelURI);
			        if (modelURI == null) return;
			        
			        Resource model = graph.getPossibleResource(modelURI);
			        if(model == null) return;
			        
			        String name = NameUtils.findFreshEscapedName(graph, "Group", model, L0.ConsistsOf);
			        
			        Resource newGroup = graph.newResource();
			        graph.claim(newGroup, L0.InstanceOf, DIA.SCLGroup);
			        graph.claimLiteral(newGroup, L0X.HasExpression, "");
			        graph.claimLiteral(newGroup, L0.HasName, name);
			        graph.claim(model, L0.ConsistsOf, newGroup);
	
				}
	
			});
		
		} catch (DatabaseException e) {

			Logger.defaultLogError(e);
			
		}

	}

}
