package org.simantics.diagram.profile.request;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.profile.ProfileUtils;

public class PossibleProfilePartName extends BinaryRead<Resource, String, Resource> {

	public PossibleProfilePartName(Resource profile, String name) {
		super(profile, name);
	}

	public Resource process(ReadGraph graph, Resource resource) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);
		
    	if(graph.isInstanceOf(resource, DIA.Profile)) {

    		String name = graph.getPossibleRelatedValue(resource, L0.HasName, Bindings.STRING);
    		if(parameter2.equals(name)) return resource;
    		
    		for(Resource child : ProfileUtils.getProfileChildren(graph, resource)) {
    			Resource result = process(graph, child);
    			if(result != null) return result;
    		}
    		
    	} else if(graph.isInstanceOf(resource, DIA.ProfileEntry)) {

    		String name = graph.getPossibleRelatedValue(resource, L0.HasName, Bindings.STRING);
    		if(parameter2.equals(name)) return resource;

		}
    	
    	return null;
    	
	}
	
	@Override
	public Resource perform(ReadGraph graph) throws DatabaseException {
		return process(graph, parameter);
	}
	
}
