/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.rendering;

import gnu.trove.set.hash.THashSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.List;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.rendering.ConnectionStyle;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;

public class StyledRouteGraphRenderer
implements IRouteGraphRenderer,
Serializable {
    private static final BasicStroke GUIDE_LINE_STROKE = new BasicStroke(0.1f);
    private static final Color GUIDE_LINE_COLOR = new Color(255, 255, 255);
    private static final long serialVersionUID = 1564960933064029020L;
    protected final ConnectionStyle style;
    protected static ThreadLocal<Cache> caches = ThreadLocal.withInitial(() -> new Cache());

    public StyledRouteGraphRenderer(ConnectionStyle style) {
        if (style == null) {
            throw new NullPointerException("null style");
        }
        this.style = style;
    }

    public ConnectionStyle getStyle() {
        return this.style;
    }

    @Override
    public void render(Graphics2D g, RouteGraph rg) {
        Cache cache = caches.get();
        Path2D path = cache.path;
        THashSet<RoutePoint> branchPoints = cache.branchPoints;
        path.reset();
        rg.getPath2D(path);
        this.style.drawPath(g, path, false);
        branchPoints.clear();
        for (RouteLine line : rg.getLines()) {
            this.renderLine(g, line, false);
            StyledRouteGraphRenderer.collectBranchPoints(line, branchPoints);
        }
        for (RouteLine line : rg.getTransientLines()) {
            this.renderLine(g, line, true);
            StyledRouteGraphRenderer.collectBranchPoints(line, branchPoints);
        }
        for (RoutePoint point : branchPoints) {
            this.style.drawBranchPoint(g, point.getX(), point.getY());
        }
    }

    private static void collectBranchPoints(RouteLine line, THashSet<RoutePoint> branchPoints) {
        List<RoutePoint> points = line.getPoints();
        int i = 1;
        while (i < points.size() - 1) {
            RoutePoint point = points.get(i);
            branchPoints.add((Object)point);
            ++i;
        }
    }

    private void renderLine(Graphics2D g, RouteLine line, boolean isTransient) {
        if (line.getPoints().size() == 0) {
            System.err.println("Route line does not contain any points (data = " + line.getData() + ").");
            return;
        }
        RoutePoint p1 = line.getBegin();
        RoutePoint p2 = line.getEnd();
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        boolean isHorizontal = line.isHorizontal();
        if (isHorizontal) {
            ILineEndStyle style;
            RouteTerminal terminal;
            if (p1 instanceof RouteTerminal) {
                terminal = (RouteTerminal)p1;
                style = terminal.getRenderStyle();
                style.render(g, x1, y1, 2);
                x1 += style.getLineEndLength(0);
            }
            if (p2 instanceof RouteTerminal) {
                terminal = (RouteTerminal)p2;
                style = terminal.getRenderStyle();
                style.render(g, x2, y2, 0);
                x2 -= style.getLineEndLength(2);
            }
        } else {
            ILineEndStyle style;
            RouteTerminal terminal;
            if (p1 instanceof RouteTerminal) {
                terminal = (RouteTerminal)p1;
                style = terminal.getRenderStyle();
                style.render(g, x1, y1, 3);
                y1 += style.getLineEndLength(1);
            }
            if (p2 instanceof RouteTerminal) {
                terminal = (RouteTerminal)p2;
                style = terminal.getRenderStyle();
                style.render(g, x2, y2, 1);
                y2 -= style.getLineEndLength(3);
            }
        }
    }

    @Override
    public void renderGuides(Graphics2D g, RouteGraph rg) {
        Path2D.Double path = new Path2D.Double();
        for (RouteLine line : rg.getLines()) {
            double ady;
            RoutePoint p1 = line.getBegin();
            RoutePoint p2 = line.getEnd();
            double dx = p2.getX() - p1.getX();
            double dy = p2.getY() - p1.getY();
            double adx = Math.abs(dx);
            if (adx > (ady = Math.abs(dy))) {
                dx = adx > 4.0 ? 0.5 * dx - Math.signum(dx) : (dx *= 0.25);
                ((Path2D)path).moveTo(p1.getX() + dx, p1.getY());
                ((Path2D)path).lineTo(p2.getX() - dx, p2.getY());
                continue;
            }
            dy = ady > 4.0 ? 0.5 * dy - Math.signum(dy) : (dy *= 0.25);
            ((Path2D)path).moveTo(p1.getX(), p1.getY() + dy);
            ((Path2D)path).lineTo(p2.getX(), p2.getY() - dy);
        }
        g.setStroke(GUIDE_LINE_STROKE);
        g.setColor(GUIDE_LINE_COLOR);
        g.draw(path);
    }

    public int hashCode() {
        return this.style.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyledRouteGraphRenderer other = (StyledRouteGraphRenderer)obj;
        return this.style.equals(other.style);
    }

    private static class Cache {
        Path2D path = new Path2D.Double();
        THashSet<RoutePoint> branchPoints = new THashSet();

        private Cache() {
        }
    }
}

