/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection.tests.actions;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;

import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLineHalf;
import org.simantics.diagram.connection.actions.IAction;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;

public class HighlightReconnectPointsAction implements IAction {

    public static final double DEGENERATED_LINE_LENGTH = 0.8;
    public static final double CROSS_SIZE = 0.5;

    RouteGraph rg;
    double crossSize;

    public HighlightReconnectPointsAction(RouteGraph rg) {
        this(rg, CROSS_SIZE);
    }

    public HighlightReconnectPointsAction(RouteGraph rg, double crossSize) {
        this.rg = rg;
        this.crossSize = crossSize;
    }

    @Override
    public void render(Graphics2D g, IRouteGraphRenderer renderer, double mouseX, double mouseY) {
        renderer.render(g, rg);
        for(RouteLineHalf lh : rg.getLineHalves()) {
            if(lh.getLine().getLength() < DEGENERATED_LINE_LENGTH)
                continue;
            double x = lh.getLink().getX();
            double y = lh.getLink().getY();
            if(lh.getLine().isHorizontal()) {
                if(lh.getLink() == lh.getLine().getBegin())
                    x += crossSize*2;
                else
                    x -= crossSize*2;
            }
            else {
                if(lh.getLink() == lh.getLine().getBegin())
                    y += crossSize*2;
                else
                    y -= crossSize*2;
            }
            g.draw(new Line2D.Double(x-crossSize,y-crossSize,x+crossSize,y+crossSize));
            g.draw(new Line2D.Double(x-crossSize,y+crossSize,x+crossSize,y-crossSize));
        }
    }

}
