/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection.tests;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.Semaphore;

public class ImageViewer extends Frame {

    private static final long serialVersionUID = -5587530298886724404L;
    
    Image image;
    Semaphore sem = new Semaphore(0);
    
    public ImageViewer(Image image) throws HeadlessException {
        this.image = image;
        
        addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                dispose();
                sem.release();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(image, 0, 0, null);
    }

    public static void run(Image image) {
        ImageViewer frame = new ImageViewer(image);
        
        frame.setSize(image.getWidth(null), image.getHeight(null));
        frame.setVisible(true);
        
        try {
            frame.sem.acquire();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
    
}
