/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection.rendering.arrows;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;


/**
 * @author Hannu Niemist&ouml;
 */
public enum ArrowExampleLineEndStyle implements ILineEndStyle, Serializable {
    INSTANCE;

    public static final double length = 8.0;
    public static final double width = 4.0;
    public static final double space = 10.0;
    
    @Override
    public void render(Graphics2D g, double x, double y, int dir) {
        AffineTransform old = g.getTransform();
        g.translate(x, y);
        g.rotate(dir*Math.PI*0.5);

        //g.setColor(Color.BLACK);

        g.fill(new Rectangle2D.Double(
                -10, -10, 20, 20
                ));

        Path2D.Double path = new Path2D.Double();
        path.moveTo(-space, 0);
        path.lineTo(-length-space, -width);
        path.lineTo(-length-space, +width);
        path.closePath();

        g.fill(path);
        g.setTransform(old);
    }

    @Override
    public double getLineEndLength(int direction) {
        return length+space;
    }
}
