/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection.actions;

import gnu.trove.map.hash.THashMap;

import java.awt.Graphics2D;

import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;

public class ReconnectTerminalAction implements IReconnectAction {
    
    RouteGraph rg;    
    RouteGraph rgc;
    RouteTerminal terminal;
    
    public ReconnectTerminalAction(RouteGraph rg, RouteGraph rgc, RouteTerminal terminal) {
        this.rg = rg;
        this.rgc = rgc;
        this.terminal = terminal;
    }

    @Override
    public void render(Graphics2D g, IRouteGraphRenderer renderer, double mouseX, double mouseY) {
        THashMap<Object, Object> map = new THashMap<Object, Object>();
        RouteGraph rgcc = rgc.copy(map);
        RouteTerminal t1 = (RouteTerminal)map.get(terminal);
        if(rgcc.connectTerminal(t1, mouseX, mouseY, TOLERANCE)) {
            renderer.render(g, rgcc);
        }            
        else {            
            RouteGraph simpleConnection = new RouteGraph();
            t1 = simpleConnection.addTerminal(terminal);
            RouteTerminal t2 = simpleConnection.addTerminal(mouseX, mouseY, 
                    mouseX, mouseY,
                    mouseX, mouseY, 15);
            simpleConnection.link(t1, t2);
            renderer.render(g, simpleConnection);
            
            renderer.render(g, rgc);
        }
    }

    @Override
    public void finish(double x, double y) {
        if(rgc.connectTerminal(terminal, x, y, TOLERANCE))
            rg.replaceBy(rgc);
    }

}
