package org.simantics.debug.graphical.model;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public abstract class Content {
    double radiusX;
    double radiusY;
    
    public abstract void render(Graphics2D g);
    
    public void render(Graphics2D g, double x, double y) {
        AffineTransform old = g.getTransform();
        g.translate(x, y);
        render(g);
        g.setTransform(old);
    }
    

    public void render(Graphics2D g, AffineTransform trans) {
        AffineTransform old = g.getTransform();
        g.transform(trans);
        render(g);
        g.setTransform(old);
    }
}
