/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.osgi.framework.Bundle;
import org.simantics.debug.browser.internal.Activator;
import org.simantics.debug.browser.servlet.ResourceBrowserServlet;

public class DebugBrowserServer {
    private static final String CONTEXT_PATH = "/debug";
    private final Server server = new Server();
    private final ServerConnector connector = new ServerConnector(this.server);

    public DebugBrowserServer(String resourcePath) throws Exception {
        this.connector.setHost("localhost");
        this.connector.setPort(0);
        this.server.setConnectors(new Connector[]{this.connector});
        ServletHandler handler = new ServletHandler();
        ServletHolder holder = new ServletHolder(ResourceBrowserServlet.class);
        handler.addServletWithMapping(holder, "/*");
        ServletContextHandler contextHandler = new ServletContextHandler(1);
        contextHandler.setContextPath(CONTEXT_PATH);
        contextHandler.setHandler((Handler)handler);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(resourcePath);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{resourceHandler, contextHandler});
        this.server.setHandler((Handler)handlers);
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public URL getURL() {
        try {
            return new URL("http", this.connector.getHost(), this.connector.getLocalPort(), CONTEXT_PATH);
        }
        catch (MalformedURLException e) {
            Platform.getLog((Bundle)Activator.getContext().getBundle()).log((IStatus)new Status(4, "org.simantics.debug.browser", "URL construction failed", (Throwable)e));
            throw new Error(e);
        }
    }
}

