/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.internal.rewriters;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.XSupport;
import org.simantics.debug.browser.content.ResourceBrowserContent;
import org.simantics.debug.browser.content.ResourceBrowserRewriter;
import org.simantics.debug.browser.sections.ResourceInfoSection;
import org.simantics.debug.browser.utils.ValueInfo;
import org.simantics.debug.browser.utils.Values;

public enum ResourceInfoCreator implements ResourceBrowserRewriter {

    INSTANCE;

    @Override
    public void rewrite(ReadGraph graph, ResourceBrowserContent content) throws DatabaseException {
        XSupport xs = graph.getService(XSupport.class);
        boolean immutable = xs.getImmutable(content.resource);
        ValueInfo valueInfo = Values.getPossibleValueInfo(graph, content.resource);
        if (valueInfo != null || immutable) {
            content.putSection(ResourceInfoSection.class, new ResourceInfoSection(valueInfo, immutable));
        }
    }

    @Override
    public double getPriority() {
        return 0;
    }

}
