package org.simantics.db.testing.common;

import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;

public abstract class WriteQuery extends WriteRequest {
	
	/**
	 * 
	 */
	private final TestBase testBase;

	/**
	 * @param testBase
	 */
	public WriteQuery(TestBase testBase) {
		this.testBase = testBase;
	}

	/**
	 * Since some SimpleGraphRequest can only handle Exceptions, we need to wrap other Throwables inside Exceptions
	 * @throws Exception 
	 */
	@Override
	public final void perform(WriteGraph g) throws DatabaseException {
		try {
			run(g);
		} catch(Throwable t) {
            new Exception().printStackTrace();
			t.printStackTrace();
    		if (null == this.testBase.exception2)
    			this.testBase.exception2 = t;
    		if (t instanceof Exception)
    			throw new DatabaseException(t);
    		throw new DatabaseException("Wrapping thrown non exception to exception.", t);
		}
	}
	
	public abstract void run(WriteGraph g) throws Throwable;
	
}