package org.simantics.db.testing.common;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

import org.eclipse.core.runtime.Platform;
import org.simantics.db.Driver;
import org.simantics.db.Driver.Management;
import org.simantics.db.Manager;
import org.simantics.db.ServerI;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.indexing.DatabaseIndexing;

/**
 * ProCore specific test handler.
 *
 */
public class AcornTestHandler {
    // private final TestSettings testSettings;
    private final Driver driver;
    private final File dbFolder;

    AcornTestHandler(TestSettings testSettings, String dbFolderName) throws DatabaseException {
        // this.testSettings = testSettings;
        driver = Manager.getDriver("acorn");
        if (driver == null)
            throw new IllegalArgumentException("No driver found for acorn!");
        if (null == dbFolderName)
            dbFolder = Platform.getLocation().append("db").toFile();
        else
            dbFolder = new File(dbFolderName);
    }

    void initNew() throws DatabaseException {
        Management m = getManagement();
        if (m.exist()) {
            m.delete();
        }
        deleteIndexes();
        m.create();
    }

    void initIfNeccessary() throws DatabaseException {
        Management m = getManagement();
        if (!m.exist()) {
            m.create();
            deleteIndexes();
        }
    }

    private void deleteIndexes() throws DatabaseException {
        try {
            DatabaseIndexing.deleteAllIndexes();
        } catch (IOException e) {
            throw new DatabaseException("Failed to delete all existing indexes", e);
        }
    }

    public Session getSession() throws DatabaseException {
        // Note that we normally user authentication agent for user
        // identification.
        Properties props = new Properties();
        props.setProperty("user", "Default User");
        props.setProperty("password", "");
        return driver.getSession(dbFolder.getAbsolutePath(), props);
    }

    public ServerI getServer() throws DatabaseException {
        return driver.getServer(dbFolder.getAbsolutePath(), null);
    }

    public Management getManagement() throws DatabaseException {
        return driver.getManagement(dbFolder.getAbsolutePath(), null);
    }

}