/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ResourceSet;
import org.simantics.db.Statement;


/**
 * @author Antti Villberg
 */
public interface CollectionSupport {

	public interface ConcurrentSet<T> {
		boolean add(AsyncReadGraph graph, T item);
		Collection<T> toCollection();
	}
	
	<T, I> T createMap(Class<I> clazz);
	<T, I> T createObjectResourceMap(Class<I> clazz);
	<T, I> T createObjectResourceMap(Class<I> clazz, int capacity);
	Set<Resource> createSet();
	Set<Resource> createSet(int capacity);
	List<Resource> createList();
	List<Resource> createList(int capacity);
	List<Resource> asSortedList(Collection<Resource> set);
	void sort(List<Resource> list);
	Collection<Statement> createStatementList();
	ResourceSet getResourceSet(ReadGraph graph, Collection<Resource> resources);
    ResourceSet getResourceSet(ReadGraph graph, Resource ... rs);
	
	

}
