/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.exception;

import org.simantics.db.service.UndoRedoSupport;

/**
 * An exception thrown by {@link UndoRedoSupport} to indicate the lack of
 * history for performing undo or redo operations. This is mainly an
 * informational exception, indicating an operation could not be performed. For
 * this reason the exception should be presented to clients in a discreet
 * manner.
 */
public class NoHistoryException extends ServiceException {

    private static final long serialVersionUID = 4224735839986999952L;

    public NoHistoryException() {
        super("");
    }

    public NoHistoryException(String message, Throwable cause) {
        super(message, cause);
    }

    public NoHistoryException(String message) {
        super(message);
    }

    public NoHistoryException(Throwable cause) {
        super(cause);
    }

}
