/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

/**
 * An object representing a single (s,p,o) statement triple in the graph.
 * 
 * These can be stored between transactions and later used with any
 * graph that has a Session with the same database.
 * 
 * @author Tuukka Lehtonen
 */
public interface Statement {

    Statement[] NONE = new Statement[0];

    Resource getSubject();
    Resource getPredicate();
    Resource getObject();
    
    boolean isAsserted(Resource subject);

}