/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import java.util.Properties;

import org.simantics.db.exception.DatabaseException;

/**
 * Extended Server Interface
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public interface ServerEx extends ServerI {

	/**
	 * Create session with user given properties.
	 * Properties:
	 *   o user           - username
	 *   o password       - password
	 *
	 * @param info
	 * @return session
	 * @throws DatabaseException
	 */
	public Session createSession(Properties info)
	throws DatabaseException;

	/**
	 * Create session with user given properties.
	 * Properties:
	 *   o user           - username
	 *   o password       - password
	 *
	 * @param info
	 * @return service locator
	 * @throws DatabaseException
	 */
	public ServiceLocator getServiceLocator(Properties info) throws DatabaseException;
}
