/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.service.SerialisationSupport;

/**
 * @deprecated use {@link SerialisationSupport} instead
 */
@Deprecated
public interface ResourceSerializer {

    /**
     * Allocates and returns an identifier that can be stored persistently over
     * time in a client and the database will be able to give you the
     * corresponding Resource at a later time, until all statements of the
     * resource are removed or the identifier is released by
     * {@link #releaseRandomAccessForResource(String)}.
     * 
     * <p>
     * If random access is requested multiple times for a particular resource,
     * the allocated ID's should be separate and each need to be released
     * separately.
     * 
     * <p>
     * The format of the generated ID's should be such that they do not contain
     * ':' characters.
     * 
     * <p>
     * To retrieve the Resource for the generated ID later a read transaction is
     * needed where {@link ReadGraph#getResource(String)} can be used.
     * 
     * @param resource
     * @return a persistent identifier
     * @throws InvalidResourceReferenceException ??? does this ever need to be
     *         thrown ???
     */
    @Deprecated // in favor of getRandomAccessId
    String createRandomAccessId(Resource resource)
    throws InvalidResourceReferenceException;

    long getRandomAccessId(Resource resource) throws DatabaseException;
    int getTransientId(Resource resource) throws DatabaseException;

    /**
     * 
     * @param id
     * @return
     * @throws InvalidResourceReferenceException
     */
    @Deprecated // in favor of getResource(long)
    Resource getResource(String randomAccessId)
    throws InvalidResourceReferenceException;

    Resource getResource(long randomAccessId) throws DatabaseException;

    Resource getResource(int transientId) throws DatabaseException;

    /**
     * @param identifier an identifier for a previously created random access
     *        resource id using
     *        {@link #createRandomAccessForResource(Resource)}.
     * @return <code>true</code> if the id was successfully released and
     *         <code>false</code> if the id did not exist.
     * @throws InvalidResourceReferenceException
     */
    boolean disposeRandomAccessId(String randomAccessId)
    throws InvalidResourceReferenceException;

}
