/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import org.simantics.db.service.SessionMonitorSupport;

/**
 * A context used for accessing {@link Session} internal state information.
 * The context is attained through {@link SessionMonitorSupport}.
 * 
 * @see SessionMonitorSupport
 * @see SessionVariables
 */
public interface MonitorContext {

    /**
     * Get value for specified integer variable.
     * 
     * @param key the variable
     * @return value or -1 for unrecognized variables
     */
    int getInteger(String key);

    /**
     * Get value for specified integer variable.
     * 
     * @param key the variable
     * @return value or <code>null</code> for unrecognized variables
     */
    String getString(String key);

}
