/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.runtime.function.Function1;

/**
 * @author Antti Villberg
 * @since 1.36.0
 */
public interface ConverterComputationalValue extends ComputationalValue {

    /**
     * This computes the expression function that shall be called with given context
     * as defined in
     * {@link ReadGraph#getRelatedValue2(Resource, Resource, Object, org.simantics.databoard.binding.Binding)}.
     *
     * <p>
     * Context can be Resource (literal) or Variable. With Resource context this
     * gets called with <code>(null, null, literal resource)</code>. With Variable
     * property context this gets called with
     * <code>(represents of parent, represents, predicate resource)</code>.
     */
    Function1<Object,Object> getFunction(ReadGraph graph, Resource s, Resource o, Resource p) throws DatabaseException;

}
