/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.simantics.db.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 */
public class GlobalServiceInitializer implements ServiceInitializer {

    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalServiceInitializer.class);

    private static final String PLUGIN_ID           = "org.simantics.db.services";

    private static final String SERVICE_INITIALIZER = "serviceInitializer";

    public static final int     INITIALIZER_ERROR   = 1;

    @Override
    public IStatus initialize(final Session s) {
        MultiStatus problems = new MultiStatus(PLUGIN_ID, INITIALIZER_ERROR, "ServiceInitializer errors:", null);

        LOGGER.info("Initializing..");
        // Initialize adaption service
        merge(problems, new AdaptionServiceInitializer().initialize(s));

        //s.registerService(StructuralResourceListener.class, new StructuralResourceListenerImpl(s));

        // Find extensions if any are available
        IExtensionRegistry er = Platform.getExtensionRegistry();
        if (er != null) {
            IExtensionPoint ep = er.getExtensionPoint(PLUGIN_ID, SERVICE_INITIALIZER);
            if (ep != null) {
                for (IConfigurationElement conf : ep.getConfigurationElements()) {
                    try {
                        LOGGER.info("initialize: " + conf.getAttribute("class") + " (id=" + conf.getAttribute("id") + ")");
                        ServiceInitializer initializer = (ServiceInitializer) conf.createExecutableExtension("class");
                        merge(problems, initializer.initialize(s));
                    } catch (CoreException e) {
                        IStatus status = new Status(IStatus.ERROR, conf.getDeclaringExtension().getNamespaceIdentifier(), "ServiceInitializer instantiation failed, see exception for details.", e);
                        problems.merge(status);
                    }
                }
            }
        }
        if (problems.isOK())
            return Status.OK_STATUS;
        return problems;
    }

    public IStatus initialize(Session s, String initializerId) {
        if (initializerId == null)
            throw new IllegalArgumentException("null initializer id");

        // Find the matching service initializer extension
        for (IConfigurationElement conf : Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, SERVICE_INITIALIZER).getConfigurationElements()) {
            try {
                String id = conf.getAttribute("id");
                if (initializerId.equals(id)) {
//                    System.out.println("initialize: " + conf.getAttribute("class"));
                    ServiceInitializer initializer = (ServiceInitializer) conf.createExecutableExtension("class");
                    return initializer.initialize(s);
                }
            } catch (CoreException e) {
                return new Status(IStatus.ERROR, conf.getDeclaringExtension().getNamespaceIdentifier(), "ServiceInitializer instantiation failed, see exception for details.", e);
            }
        }
        return new Status(IStatus.ERROR, PLUGIN_ID, "ServiceInitializer extension with id '" + initializerId + "' not found.", null);
    }

    private void merge(MultiStatus result, IStatus status) {
        if (!status.isOK())
            result.add(status);
    }

}
