/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.Connection;
import org.simantics.db.server.internal.NotConnectedException;

class Channel {
    private SelectionKey selectionKey = null;
    private SocketChannel socketChannel = null;

    Channel() {
    }

    void register(Selector selector, Connection connection) throws ClosedChannelException {
        if (this.socketChannel == null) {
            throw new ClosedChannelException();
        }
        this.socketChannel.register(selector, 8, connection);
    }

    void prepare4Connection(SocketChannel socketChannel, InetSocketAddress address) throws ProCoreException, IOException {
        if (socketChannel == null) {
            throw new NotConnectedException("Illegal argument. No socket channel to connect to.");
        }
        if (address == null) {
            throw new NotConnectedException("Illegal argument. No address to connect to.");
        }
        if (this.socketChannel != null) {
            throw new NotConnectedException("Illegal state. Socket channel already created. this=" + this);
        }
        socketChannel.configureBlocking(false);
        boolean connected = socketChannel.connect(address);
        if (connected) {
            // empty if block
        }
        this.socketChannel = socketChannel;
    }

    synchronized void connect(SelectionKey key) {
        this.selectionKey = key;
        this.socketChannel = (SocketChannel)key.channel();
    }

    synchronized void disconnect() {
        if (this.selectionKey == null) {
            return;
        }
        try {
            try {
                this.selectionKey.interestOps(0);
                this.selectionKey.cancel();
                this.selectionKey.selector().wakeup();
            }
            catch (CancelledKeyException cancelledKeyException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                this.socketChannel.socket().close();
            }
            catch (IOException iOException) {}
        }
        finally {
            this.selectionKey = null;
            this.socketChannel = null;
        }
    }

    synchronized boolean isConnected() {
        boolean ret = this.selectionKey != null && this.socketChannel.isConnected();
        return ret;
    }

    synchronized SocketChannel socket() throws IOException {
        if (this.socketChannel == null) {
            throw new IOException("Socket channel is null.");
        }
        return this.socketChannel;
    }

    synchronized void listenReadEvents() throws IOException {
        if (this.selectionKey == null) {
            throw new IOException("Trying to listen connection which is not connected.");
        }
        int ops = this.selectionKey.interestOps() | 1;
        this.selectionKey.interestOps(ops);
        this.selectionKey.selector().wakeup();
    }
}

