/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class UpdateClusterFunction extends AbstractFunction {
    public byte[] operation = null;
    public UpdateClusterFunction() {
        super(MessageNumber.UpdateClusterRequest, MessageNumber.UpdateClusterResponse);
    }
    public UpdateClusterFunction(byte[] operation) {
        super(MessageNumber.UpdateClusterRequest, MessageNumber.UpdateClusterResponse);
        this.operation = operation;
    }
    @Override
    public DataBuffer serialize(ByteOrder byteOrder) {
        buffer = new DataBuffer(ByteBuffer.wrap(operation));
        buffer.position(operation.length);
        buffer.mark();
        return buffer;
    }
    @Override
    public void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        receivedNumber = receivedNumber_;
        if (notRightDataForUs())
            return;
        gotResponse();
    }
}
