/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

import java.nio.ByteOrder;

public class GetResourceSegmentFunction extends AbstractFunction {
    public byte[] clusterUID = null;
    public int resourceIndex = 0;
    public long segmentOffset = 0;
    public short segmentSize = 0;
    public boolean isExternalResource = false;
    public long valueSize = 0;
    public byte[] segment = null;
    public GetResourceSegmentFunction() {
        super(MessageNumber.GetResourceSegmentRequest, MessageNumber.GetResourceSegmentResponse);
    }
    public GetResourceSegmentFunction(byte[] clusterUID, int resourceIndex, long segmentOffset, short segmentSize) {
        super(MessageNumber.GetResourceSegmentRequest, MessageNumber.GetResourceSegmentResponse);
        this.clusterUID = clusterUID;
        this.resourceIndex = resourceIndex;
        this.segmentOffset = segmentOffset;
        this.segmentSize = segmentSize;
    }
    @Override
    public DataBuffer serialize(ByteOrder byteOrder) {
        buffer.clear();
        buffer.order(byteOrder);
        buffer.put(clusterUID);
        buffer.put(resourceIndex);
        buffer.put(segmentOffset);
        buffer.put(segmentSize);
        buffer.mark();
        return buffer;
    }
    @Override
    public void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        receivedNumber = receivedNumber_;
        if (notRightDataForUs())
            return;
        isExternalResource = dataBuffer.get(isExternalResource);
        valueSize = dataBuffer.get(valueSize);
        segment = dataBuffer.get(segment);
        gotResponse();
    }
}
