/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

import java.nio.ByteOrder;

public class ChangeSetUpdateEvent extends AbstractEvent {
    public long changeSetId = 0;
    public int changeSetIndex = 0;
    public int numberOfClusterChangeSets = 0;
    public int indexOfClusterChangeSet = 0;
    public byte[] clusterUID = null;
    public boolean newCluster = false;
    public byte[] data = null;
    public ChangeSetUpdateEvent() {
        super(MessageNumber.ChangeSetUpdateRequest, MessageNumber.ChangeSetUpdateResponse);
    }
    @Override
    public DataBuffer serialize(ByteOrder byteOrder) {
        buffer.clear();
        buffer.order(byteOrder);
        buffer.mark();
        return buffer;
    }
    @Override
    public void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        receivedNumber = receivedNumber_;
        if (notRightDataForUs())
            return;
        changeSetId = dataBuffer.get(changeSetId);
        changeSetIndex = dataBuffer.get(changeSetIndex);
        numberOfClusterChangeSets = dataBuffer.get(numberOfClusterChangeSets);
        indexOfClusterChangeSet = dataBuffer.get(indexOfClusterChangeSet);
        clusterUID = dataBuffer.get(clusterUID);
        newCluster = dataBuffer.get(newCluster);
        data = dataBuffer.get(data);
        gotResponse();
    }
}
