/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.PrintStream;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTranslator;
import org.simantics.db.procore.cluster.ClusterBig;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.Stopwatch;
import org.simantics.db.service.ClusterUID;

public final class TestCluster {
    private static final boolean DEBUG = false;
    private static final int AddedResources = 100;
    private static final int AddedStatements = 100;
    private static final int ValueCapacity = 5;
    private final ClusterBase builtinCluster;
    private final ClusterUID BuiltinClusterUID = ClusterUID.Builtin;
    private final int BuiltinClusterKey;
    private final ClusterBase foreignCluster;
    private final ClusterUID ForeignClusterUID;
    private final ClusterBase objectCluster;
    private final ClusterUID ObjectClusterUID;
    private final ClusterTranslator support;
    PrintStream out;

    TestCluster(Session session) {
        this.ForeignClusterUID = ClusterUID.make((long)0L, (long)(ClusterUID.Builtin.second + 1L));
        this.ObjectClusterUID = ClusterUID.make((long)0L, (long)(ClusterUID.Builtin.second + 2L));
        this.out = System.out;
        this.support = ((SessionImplSocket)session).clusterTranslator;
        this.builtinCluster = this.support.getClusterByClusterUIDOrMake(this.BuiltinClusterUID);
        this.BuiltinClusterKey = this.builtinCluster.getClusterKey();
        this.foreignCluster = this.support.getClusterByClusterUIDOrMake(this.ForeignClusterUID);
        this.objectCluster = this.support.getClusterByClusterUIDOrMake(this.ObjectClusterUID);
    }

    private void testReading(ClusterI cluster, int[] resourceKeys, int[] statementKeys, int[] objectKeys, boolean onePredicateOn, int AddedStatements, boolean foreignClusterOn) throws DatabaseException {
        Stopwatch sw = new Stopwatch();
        sw.start();
        int i = 0;
        while (i < 100) {
            int resourceKey = resourceKeys[i];
            ClusterI.CompleteTypeEnum ct = cluster.getCompleteType(resourceKey, (ClusterSupport)this.support);
            if (ct != ClusterI.CompleteTypeEnum.NotComplete) {
                int ck = cluster.getCompleteObjectKey(resourceKey, (ClusterSupport)this.support);
                this.Assert(ck != 0);
                this.Assert(objectKeys[0] == ck);
            }
            TIntIntHashMap predicates = new TIntIntHashMap();
            final TIntIntHashMap countMap = new TIntIntHashMap();
            countMap.clear();
            ClusterI.ObjectProcedure<TIntIntHashMap> readObjects = new ClusterI.ObjectProcedure<TIntIntHashMap>(){

                public boolean execute(TIntIntHashMap objects, int object) {
                    int i = objects.get(object);
                    objects.put(object, ++i);
                    return false;
                }
            };
            ClusterI.PredicateProcedure<TIntIntHashMap> readPredicates = new ClusterI.PredicateProcedure<TIntIntHashMap>(){

                public boolean execute(TIntIntHashMap set, int predicateKey, int objectIndex) {
                    set.put(predicateKey, objectIndex);
                    int i = countMap.get(predicateKey);
                    countMap.put(predicateKey, ++i);
                    return false;
                }
            };
            cluster.forPredicates(resourceKey, (ClusterI.PredicateProcedure)readPredicates, (Object)predicates, (ClusterSupport)this.support);
            if (onePredicateOn) {
                this.Assert(predicates.size() == 1);
            } else {
                this.Assert(predicates.size() == AddedStatements);
            }
            int j = 0;
            while (j < AddedStatements) {
                int pKey;
                int n = pKey = onePredicateOn ? resourceKey : statementKeys[j];
                if (onePredicateOn && foreignClusterOn) {
                    pKey = statementKeys[0];
                }
                this.Assert(predicates.contains(pKey));
                this.Assert(countMap.get(pKey) == 1);
                int oIndex = predicates.get(pKey);
                if (AddedStatements < 3) {
                    this.Assert(oIndex == 0);
                }
                TIntIntHashMap objects = new TIntIntHashMap();
                TIntIntHashMap objects2 = new TIntIntHashMap();
                cluster.forObjects(resourceKey, pKey, oIndex, (ClusterI.ObjectProcedure)readObjects, (Object)objects, (ClusterSupport)this.support);
                cluster.forObjects(resourceKey, pKey, (ClusterI.ObjectProcedure)readObjects, (Object)objects2, (ClusterSupport)this.support);
                this.Assert(objects.size() == objects2.size());
                if (onePredicateOn) {
                    this.Assert(objects.size() == AddedStatements);
                    int k = 0;
                    while (k < AddedStatements) {
                        int oKey = objectKeys[k];
                        this.Assert(objects.contains(oKey));
                        this.Assert(1 == objects.get(oKey));
                        this.Assert(objects2.contains(oKey));
                        this.Assert(1 == objects2.get(oKey));
                        ++k;
                    }
                } else {
                    this.Assert(objects.size() == 1);
                    int oKey = objectKeys[j];
                    this.Assert(objects.contains(oKey));
                    this.Assert(1 == objects.get(oKey));
                    this.Assert(objects2.contains(oKey));
                    this.Assert(1 == objects2.get(oKey));
                }
                ++j;
            }
            if (!cluster.hasValue(resourceKey, (ClusterSupport)this.support)) {
                throw new RuntimeException("hasValue() failed for resource key=" + resourceKey);
            }
            byte[] data = cluster.getValue(resourceKey, (ClusterSupport)this.support);
            this.Assert(data.length == 5);
            int l = 0;
            while (l < 5) {
                this.Assert((byte)l == data[l]);
                ++l;
            }
            ++i;
        }
        sw.stop();
        this.out.println("Elapsed time in millseconds " + sw.elapsedMilli() + " for reading.");
        this.out.println("Used space consumption in bytes: " + cluster.getUsedSpace());
    }

    private int getResourceKey(int clusterKey, int resourceIndex) throws DatabaseException {
        return ClusterTraits.createResourceKey((int)clusterKey, (int)resourceIndex);
    }

    private boolean clusterTest(boolean onePredicateOn, boolean foreignClusterOn, int AddedStatements) throws DatabaseException {
        int oKey;
        int pKey;
        int sKey;
        int resourceKey;
        String testName = "Cluster ";
        this.out.println("********************************************");
        String eo = onePredicateOn ? "on" : "off";
        String fco = foreignClusterOn ? "on" : "off";
        this.out.println(String.valueOf(testName) + " test with one predicate " + eo + ", foreign cluster " + fco);
        Stopwatch sw = new Stopwatch();
        sw.start();
        ClusterImpl cluster = ClusterImpl.make(this.BuiltinClusterUID, this.BuiltinClusterKey, (ClusterSupport)this.support);
        byte[] value = new byte[5];
        int i = 0;
        while (i < 5) {
            value[i] = (byte)i;
            ++i;
        }
        this.Assert(100 <= ClusterTraits.getMaxNumberOfResources());
        int[] resourceKeys = new int[100];
        int i2 = 0;
        while (i2 < 100) {
            resourceKeys[i2] = cluster.createResource((ClusterSupport)this.support);
            this.Assert(ClusterTraits.getResourceIndexFromResourceKey((int)resourceKeys[i2]) == i2 + 1);
            this.Assert(!cluster.isComplete(resourceKeys[i2], (ClusterSupport)this.support));
            ++i2;
        }
        int[] statementKeys = new int[AddedStatements];
        int[] objectKeys = new int[AddedStatements];
        int i3 = 0;
        while (i3 < AddedStatements) {
            if (foreignClusterOn) {
                this.Assert(AddedStatements <= ClusterTraits.getMaxNumberOfResources());
                statementKeys[i3] = this.getResourceKey(this.foreignCluster.getClusterKey(), i3 + 1);
            } else {
                this.Assert(AddedStatements <= 100);
                statementKeys[i3] = this.getResourceKey(this.builtinCluster.getClusterKey(), i3 + 1);
            }
            objectKeys[i3] = this.getResourceKey(this.objectCluster.getClusterKey(), i3 + 1);
            ++i3;
        }
        i3 = 0;
        while (i3 < 100) {
            resourceKey = resourceKeys[i3];
            int j = 0;
            while (j < AddedStatements) {
                sKey = resourceKey;
                int n = pKey = onePredicateOn ? resourceKey : statementKeys[j];
                if (onePredicateOn && foreignClusterOn) {
                    pKey = statementKeys[0];
                }
                if ((cluster = cluster.addRelation(sKey, pKey, oKey = objectKeys[j], (ClusterSupport)this.support)) == null) {
                    throw new RuntimeException("AddRelation() failed.");
                }
                if (cluster.addRelation(sKey, pKey, oKey, (ClusterSupport)this.support) != null) {
                    throw new RuntimeException("AddRelation() failed.");
                }
                ++j;
            }
            if (!(cluster = cluster.setValue(resourceKey, value, value.length, (ClusterSupport)this.support)).hasValue(resourceKey, (ClusterSupport)this.support)) {
                throw new RuntimeException("AddRelation() failed.");
            }
            byte[] data = cluster.getValue(resourceKey, (ClusterSupport)this.support);
            this.Assert(data.length == value.length);
            int l = 0;
            while (l < value.length) {
                this.Assert((byte)l == data[l]);
                ++l;
            }
            ++i3;
        }
        sw.stop();
        this.out.println("Elapsed time in milliseconds " + sw.elapsedMilli() + " for adding " + 100 + " Resources with " + AddedStatements + " statements.");
        this.testReading((ClusterI)cluster, resourceKeys, statementKeys, objectKeys, onePredicateOn, AddedStatements, foreignClusterOn);
        if (!(cluster instanceof ClusterBig)) {
            sw.restart();
            ClusterBig big = cluster.toBig((ClusterSupport)this.support);
            sw.stop();
            this.out.println("Elapsed time in milliseconds " + sw.elapsedMilli() + " for converting to big.");
            this.testReading((ClusterI)big, resourceKeys, statementKeys, objectKeys, onePredicateOn, AddedStatements, foreignClusterOn);
        }
        sw.restart();
        i = 0;
        while (i < 100) {
            resourceKey = resourceKeys[i];
            int j = 0;
            while (j < AddedStatements) {
                sKey = resourceKey;
                int n = pKey = onePredicateOn ? resourceKey : statementKeys[j];
                if (onePredicateOn && foreignClusterOn) {
                    pKey = statementKeys[0];
                }
                if (!cluster.removeRelation(sKey, pKey, oKey = objectKeys[j], (ClusterSupport)this.support)) {
                    throw new RuntimeException("RemoveRelation() failed.");
                }
                if (cluster.removeRelation(sKey, pKey, oKey, (ClusterSupport)this.support)) {
                    throw new RuntimeException("RemoveRelation() failed.");
                }
                cluster.denyRelation(sKey, pKey, oKey, (ClusterSupport)this.support);
                ++j;
            }
            if (!cluster.removeValue(resourceKey, (ClusterSupport)this.support)) {
                throw new RuntimeException("removeValue() failed.");
            }
            if (cluster.removeValue(resourceKey, (ClusterSupport)this.support)) {
                throw new RuntimeException("removeValue() failed.");
            }
            ++i;
        }
        sw.stop();
        this.out.println("Elapsed time in millseconds " + sw.elapsedMilli() + " for deleting.");
        this.out.println("Used space consumption in bytes: " + cluster.getUsedSpace());
        return false;
    }

    private void testBasic() throws DatabaseException {
        this.support.setStreamOff(true);
        try {
            int i = 100;
            while (i < 101) {
                this.clusterTest(false, false, i);
                this.clusterTest(false, true, i);
                this.clusterTest(true, false, i);
                this.clusterTest(true, true, i);
                ++i;
            }
        }
        finally {
            this.support.setStreamOff(false);
        }
    }

    private void Assert(boolean condition) throws DatabaseException {
        if (condition) {
            return;
        }
        DatabaseException e = new DatabaseException("Test failed!");
        e.printStackTrace(this.out);
        throw e;
    }

    public static void test(Session session) {
        TestCluster tc = new TestCluster(session);
        try {
            System.out.println("Begin of tests.");
            tc.testBasic();
            System.out.println("End of tests.");
        }
        catch (Throwable t) {
            throw new RuntimeException("Tests failed.", t);
        }
    }

    public static void main(String[] args) {
        TestCluster.test(null);
    }
}

