/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.IntAllocatorI;
import org.simantics.db.impl.Modifier;

final class TableIntArraySet2 {
    public static final int HeaderSize = 1;
    private static final int SIZE_OFFSET = -1;

    TableIntArraySet2() {
    }

    static int create(int[] keys, int[] vals, IntAllocatorI allocator) throws DatabaseException {
        int LENGTH = keys.length;
        if (LENGTH < 1 || LENGTH != vals.length) {
            throw new DatabaseException("Illegal argument to create TableIntArraySet2.");
        }
        int newBase = allocator.allocate(LENGTH * 2 + 1) + 1;
        int[] table = allocator.getTable();
        table[newBase + -1] = -LENGTH;
        int i = 0;
        while (i < LENGTH) {
            if (keys[i] == 0) {
                throw new DatabaseException("Illegal value to create TableIntArraySet2.");
            }
            table[newBase + i * 2] = keys[i];
            table[newBase + i * 2 + 1] = vals[i];
            ++i;
        }
        return newBase;
    }

    static boolean isArraySet(int[] table, int base) {
        return table[base + -1] < 0;
    }

    static Tables getInts(int[] table, int base) {
        int REAL_SIZE = -table[base + -1];
        assert (REAL_SIZE > 0);
        Tables t = new Tables();
        int i = 0;
        while (i < REAL_SIZE) {
            int k = table[base + i * 2];
            if (k == 0) break;
            ++i;
        }
        int size = i;
        assert (size > 0);
        t.keys = new int[size];
        t.vals = new int[size];
        i = 0;
        while (i < size) {
            t.keys[i] = table[base + i * 2];
            t.vals[i] = table[base + i * 2 + 1];
            ++i;
        }
        return t;
    }

    static int get(int[] table, int base, int aKey) {
        int REAL_SIZE = -table[base + -1];
        assert (REAL_SIZE > 0);
        int i = 0;
        while (i < REAL_SIZE) {
            if (table[base] == 0) {
                return 0;
            }
            if (aKey == table[base]) {
                return table[base + 1];
            }
            ++i;
            base += 2;
        }
        return 0;
    }

    static int addInt(int[] table, int base, int key, int val, IntAllocatorI allocator) {
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            if (key == table[base + i * 2]) {
                if (val == table[base + i * 2 + 1]) {
                    return 0;
                }
                table[base + i * 2 + 1] = val;
                return base;
            }
            if (table[base + i * 2] == 0) break;
            ++i;
        }
        if (i < size) {
            assert (table[base + i * 2] == 0);
            table[base + i * 2] = key;
            table[base + i * 2 + 1] = val;
            return base;
        }
        int newSize = size + 1;
        int newBase = allocator.allocate(newSize * 2 + 1) + 1;
        int[] newTable = allocator.getTable();
        newTable[newBase + -1] = -newSize;
        System.arraycopy(table, base, newTable, newBase, size * 2);
        newTable[newBase + size * 2] = key;
        newTable[newBase + size * 2 + 1] = val;
        return newBase;
    }

    static boolean removeInt(int[] table, int base, int key) {
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            if (key == table[base + i * 2]) break;
            if (table[base + i * 2] == 0) {
                return false;
            }
            ++i;
        }
        if (i == size) {
            return false;
        }
        int end = size - 1;
        while (end > i) {
            if (table[base + end * 2] != 0) break;
            --end;
        }
        table[base + i * 2] = table[base + end * 2];
        table[base + i * 2 + 1] = table[base + end * 2 + 1];
        table[base + end * 2] = 0;
        table[base + end * 2 + 1] = 0;
        return true;
    }

    static int getSize(int[] table, int base) {
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            if (table[base + i * 2] == 0) break;
            ++i;
        }
        return i;
    }

    static int getAllocatedSize(int[] table, int base) {
        int size = -table[base + -1];
        assert (size > 0);
        return size + 1;
    }

    static <Context> boolean foreachInt(int[] table, int base, ClusterI.PredicateProcedure<Context> procedure, Context context, Modifier modifier) throws DatabaseException {
        int size = -table[base + -1];
        assert (size > 0);
        int i = 0;
        while (i < size) {
            int pRef = table[base + i * 2];
            if (pRef == 0) break;
            int key = modifier == null ? pRef : modifier.execute(pRef);
            if (procedure.execute(context, key, table[base + i * 2 + 1])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static class Tables {
        int[] keys = null;
        int[] vals = null;
    }
}

